/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockDerrickRenderer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.IPMultiblockProperties;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.IPTemplateMultiblock;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.neoforged.neoforge.client.model.data.ModelData;

public class DerrickMultiblock
extends IPTemplateMultiblock {
    public static final DerrickMultiblock INSTANCE = new DerrickMultiblock();

    public DerrickMultiblock() {
        super(ResourceUtils.ip("multiblocks/derrick"), new BlockPos(2, 0, 2), new BlockPos(2, 0, 4), new BlockPos(5, 8, 5), IPContent.Multiblock.DERRICK);
    }

    public float getManualScale() {
        return 10.0f;
    }

    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
        consumer.accept(new DerrickMultiblockProperties());
    }

    public static class DerrickMultiblockProperties
    extends IPMultiblockProperties {
        public DerrickMultiblockProperties() {
            super(INSTANCE, 2.5, 0.5, 2.5);
        }

        @Override
        public void renderExtras(PoseStack matrix, MultiBufferSource buffer) {
            matrix.translate(0.0, 0.5, 0.0);
            DerrickMultiblockProperties.renderObj(MultiblockDerrickRenderer.DRILL, buffer, matrix);
            for (int i = 0; i < 6; ++i) {
                matrix.pushPose();
                matrix.translate(0.0, (double)i + 0.75, 0.0);
                DerrickMultiblockProperties.renderObj(i < 5 ? MultiblockDerrickRenderer.PIPE_SEGMENT : MultiblockDerrickRenderer.PIPE_TOP, buffer, matrix);
                matrix.popPose();
            }
        }

        private static void renderObj(ModelResourceLocation modelRL, @Nonnull MultiBufferSource bufferIn, @Nonnull PoseStack matrix) {
            List quads = MCUtil.getModel(modelRL).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
            PoseStack.Pose last = matrix.last();
            VertexConsumer solid = bufferIn.getBuffer(RenderType.solid());
            for (BakedQuad quad : quads) {
                solid.putBulkData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
        }
    }
}

