/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class IPBlockSlab<B extends IPBlockBase>
extends SlabBlock {
    private final B base;

    public IPBlockSlab(B base) {
        super(BlockBehaviour.Properties.ofFullCopy(base).isSuffocating(IPBlockSlab.causesSuffocation(base)).isRedstoneConductor(IPBlockSlab.isNormalCube(base)));
        this.base = base;
    }

    public int getLightBlock(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return Math.min(this.base.defaultBlockState().getLightBlock(worldIn, pos), super.getLightBlock(state, worldIn, pos));
    }

    public boolean propagatesSkylightDown(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return super.propagatesSkylightDown(state, reader, pos) || this.base.defaultBlockState().propagatesSkylightDown(reader, pos);
    }

    public static BlockBehaviour.StatePredicate causesSuffocation(Block base) {
        return (state, world, pos) -> base.defaultBlockState().isSuffocating(world, pos) && state.getValue((Property)TYPE) == SlabType.DOUBLE;
    }

    public static BlockBehaviour.StatePredicate isNormalCube(Block base) {
        return (state, world, pos) -> base.defaultBlockState().isRedstoneConductor(world, pos) && state.getValue((Property)TYPE) == SlabType.DOUBLE;
    }
}

