/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class IPSaveData
extends SavedData {
    public static final String dataName = "ImmersivePetroleum-SaveData";
    private static IPSaveData INSTANCE;

    public IPSaveData() {
        INSTANCE = this;
    }

    public IPSaveData(CompoundTag nbt, HolderLookup.Provider provider) {
        INSTANCE = this;
        this.load(nbt, provider);
    }

    @Nonnull
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag lubricatedList = new ListTag();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            if (info == null) continue;
            CompoundTag tag = info.writeToNBT();
            lubricatedList.add((Object)tag);
        }
        nbt.put("lubricated", (Tag)lubricatedList);
        return nbt;
    }

    private void load(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag lubricatedList = nbt.getList("lubricated", 10);
        LubricatedHandler.lubricatedTiles.clear();
        lubricatedList.stream().map(tag -> new LubricatedHandler.LubricatedTileInfo((CompoundTag)tag)).forEach(info -> LubricatedHandler.lubricatedTiles.add((LubricatedHandler.LubricatedTileInfo)info));
    }

    public static void markDirty() {
        if (INSTANCE != null) {
            INSTANCE.setDirty();
        }
    }
}

