/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.multiblock;

import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.client.model.ModelPumpjack;
import flaxbeard.immersivepetroleum.client.render.multiblock.IPMultiblockRenderer;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.PumpjackLogic;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MultiblockPumpjackRenderer
extends IPMultiblockRenderer<PumpjackLogic.State> {
    private static final Supplier<IPModel> pumpjackarm = IPModels.getSupplier("pumpjackarm");

    public MultiblockPumpjackRenderer() {
        super(() -> PumpjackMultiblock.INSTANCE);
    }

    public int getViewDistance() {
        return 100;
    }

    public void render(@Nonnull MultiblockBlockEntityMaster<PumpjackLogic.State> te, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRemoved() || te.getLevel() == null || !te.getLevel().hasChunkAt(te.getBlockPos())) {
            return;
        }
        transform.pushPose();
        Direction rotation = te.getHelper().getContext().getLevel().getOrientation().front();
        switch (rotation) {
            case NORTH: {
                transform.mulPose(ROT_90);
                transform.translate(-6.0f, 0.0f, -1.0f);
                break;
            }
            case EAST: {
                transform.translate(-5.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                transform.mulPose(ROT_270);
                transform.translate(-5.0f, 0.0f, -2.0f);
                break;
            }
            case WEST: {
                transform.mulPose(ROT_180);
                transform.translate(-6.0f, 0.0f, -2.0f);
                break;
            }
        }
        ModelPumpjack model = (ModelPumpjack)pumpjackarm.get();
        if (model != null) {
            float ticks = ((PumpjackLogic.State)te.getHelper().getState()).activeTicks + (((PumpjackLogic.State)te.getHelper().getState()).wasActive ? partialTicks : 0.0f);
            model.ticks = 1.5f * ticks;
            model.renderToBuffer(transform, buffer.getBuffer(model.renderType(ModelPumpjack.TEXTURE)), combinedLightIn, combinedOverlayIn, -1);
        }
        transform.popPose();
    }
}

