/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.multiblock;

import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.render.multiblock.Face;
import flaxbeard.immersivepetroleum.client.render.multiblock.IPMultiblockRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.QuickDraw;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater.HydroTreaterLogic;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;

public class MultiblockHydrotreaterRenderer
extends IPMultiblockRenderer<HydroTreaterLogic.State> {
    static final Face ACTIVE_FRONT = Face.of(0, 0, 32, 40);
    static final Face ACTIVE_SIDE = Face.of(32, 0, 16, 40);

    public MultiblockHydrotreaterRenderer() {
        super(() -> HydroTreaterMultiblock.INSTANCE);
    }

    public void render(@Nonnull MultiblockBlockEntityMaster<HydroTreaterLogic.State> te, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRemoved() || te.getLevel() == null || !te.getLevel().hasChunkAt(te.getBlockPos())) {
            return;
        }
        if (((HydroTreaterLogic.State)te.getHelper().getState()).cooldownTicks <= 0) {
            return;
        }
        combinedOverlayIn = OverlayTexture.NO_OVERLAY;
        transform.pushPose();
        Direction rotation = te.getHelper().getContext().getLevel().getOrientation().front();
        switch (rotation) {
            case EAST: {
                transform.mulPose(ROT_270);
                transform.translate(0.0f, 0.0f, 0.0f);
                break;
            }
            case SOUTH: {
                transform.mulPose(ROT_180);
                transform.translate(-1.0f, 0.0f, 0.0f);
                break;
            }
            case WEST: {
                transform.mulPose(ROT_90);
                transform.translate(-1.0f, 0.0f, 1.0f);
                break;
            }
            case NORTH: {
                transform.translate(0.0f, 0.0f, 1.0f);
                break;
            }
        }
        VertexConsumer buf = bufferIn.getBuffer(IPRenderTypes.HYDROTREATER_ACTIVE_OVERLAY);
        if (te.getHelper().getContext().getLevel().getOrientation().mirrored()) {
            transform.pushPose();
            QuickDraw draw = new QuickDraw(buf, transform, -1, combinedOverlayIn, 0xF000F0);
            Face face1 = ACTIVE_SIDE;
            draw.vertex(1.0015f, 0.5f + face1.h16(), 0.0f, face1.u0(), face1.v0());
            draw.vertex(1.0015f, 0.5f + face1.h16(), face1.w16(), face1.u1(), face1.v0());
            draw.vertex(1.0015f, 0.5f, face1.w16(), face1.u1(), face1.v1());
            draw.vertex(1.0015f, 0.5f, 0.0f, face1.u0(), face1.v1());
            Face face0 = ACTIVE_SIDE;
            draw.vertex(-1.0015f, 0.5f, face0.w16(), face0.u0(), face0.v1());
            draw.vertex(-1.0015f, 0.5f + face0.h16(), face0.w16(), face0.u0(), face0.v0());
            draw.vertex(-1.0015f, 0.5f + face0.h16(), 0.0f, face0.u1(), face0.v0());
            draw.vertex(-1.0015f, 0.5f, 0.0f, face0.u1(), face0.v1());
            Face face2 = ACTIVE_FRONT;
            draw.vertex(face2.w16() - 1.0f, 0.5f, 1.0015f, face2.u0(), face2.v1());
            draw.vertex(face2.w16() - 1.0f, 0.5f + face2.h16(), 1.0015f, face2.u0(), face2.v0());
            draw.vertex(-1.0f, 0.5f + face2.h16(), 1.0015f, face2.u1(), face2.v0());
            draw.vertex(-1.0f, 0.5f, 1.0015f, face2.u1(), face2.v1());
            transform.popPose();
        } else {
            transform.pushPose();
            QuickDraw draw = new QuickDraw(buf, transform, -1, combinedOverlayIn, 0xF000F0);
            Face face1 = ACTIVE_SIDE;
            draw.vertex(2.0015f, 0.5f + face1.h16(), 0.0f, face1.u0(), face1.v0());
            draw.vertex(2.0015f, 0.5f + face1.h16(), face1.w16(), face1.u1(), face1.v0());
            draw.vertex(2.0015f, 0.5f, face1.w16(), face1.u1(), face1.v1());
            draw.vertex(2.0015f, 0.5f, 0.0f, face1.u0(), face1.v1());
            Face face0 = ACTIVE_SIDE;
            draw.vertex(-0.0015f, 0.5f, face0.w16(), face0.u0(), face0.v1());
            draw.vertex(-0.0015f, 0.5f + face0.h16(), face0.w16(), face0.u0(), face0.v0());
            draw.vertex(-0.0015f, 0.5f + face0.h16(), 0.0f, face0.u1(), face0.v0());
            draw.vertex(-0.0015f, 0.5f, 0.0f, face0.u1(), face0.v1());
            Face face2 = ACTIVE_FRONT;
            draw.vertex(face2.w16(), 0.5f, 1.0015f, face2.u1(), face2.v1());
            draw.vertex(face2.w16(), 0.5f + face2.h16(), 1.0015f, face2.u1(), face2.v0());
            draw.vertex(0.0f, 0.5f + face2.h16(), 1.0015f, face2.u0(), face2.v0());
            draw.vertex(0.0f, 0.5f, 1.0015f, face2.u0(), face2.v1());
            transform.popPose();
        }
        transform.popPose();
    }
}

