/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.multiblock;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.render.multiblock.IPMultiblockRenderer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.DerrickMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.neoforge.client.model.data.ModelData;

public class MultiblockDerrickRenderer
extends IPMultiblockRenderer<DerrickLogic.State> {
    public static final ModelResourceLocation DRILL = ResourceUtils.ipModel("multiblock/dyn/derrick_drill");
    public static final ModelResourceLocation PIPE_SEGMENT = ResourceUtils.ipModel("multiblock/dyn/derrick_pipe_segment");
    public static final ModelResourceLocation PIPE_TOP = ResourceUtils.ipModel("multiblock/dyn/derrick_pipe_top");

    public MultiblockDerrickRenderer() {
        super(() -> DerrickMultiblock.INSTANCE);
    }

    public int getViewDistance() {
        return 512;
    }

    public void render(MultiblockBlockEntityMaster<DerrickLogic.State> te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRemoved() || te.getLevel() == null || !te.getLevel().hasChunkAt(te.getBlockPos())) {
            return;
        }
        matrix.pushPose();
        float rot = (float)((DerrickLogic.State)te.getHelper().getState()).rotation + (((DerrickLogic.State)te.getHelper().getState()).drilling ? 10.0f * partialTicks : 0.0f);
        matrix.translate(0.5, 1.0, 0.5);
        matrix.mulPose(Axis.YP.rotationDegrees(rot));
        this.renderObj(DRILL, bufferIn, matrix, combinedLightIn, combinedOverlayIn);
        float pipeHeight = -(rot / 360.0f);
        for (int i = 0; i < 6; ++i) {
            float y = pipeHeight + (float)i;
            if (!((double)y > -1.0)) continue;
            matrix.pushPose();
            matrix.translate(0.0, (double)y + 0.75, 0.0);
            this.renderObj(i < 5 ? PIPE_SEGMENT : PIPE_TOP, bufferIn, matrix, combinedLightIn, combinedOverlayIn);
            matrix.popPose();
        }
        matrix.popPose();
    }

    private void renderObj(ModelResourceLocation modelRL, @Nonnull MultiBufferSource bufferIn, @Nonnull PoseStack matrix, int light, int overlay) {
        List quads = MCUtil.getModel(modelRL).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        PoseStack.Pose last = matrix.last();
        VertexConsumer solid = bufferIn.getBuffer(RenderType.solid());
        for (BakedQuad quad : quads) {
            solid.putBulkData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }
}

