/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.debugging;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirBoundingBox;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.render.debugging.DebugText;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.OilTankLogic;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokerUnitLogic;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokingChamber;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower.DistillationTowerLogic;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater.HydroTreaterLogic;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.FlarestackTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.GasGeneratorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionData;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionPos;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Matrix4f;

public class DebugRenderHandler {
    static final DebugText debugText = new DebugText();

    private boolean isHoldingDebugItem(Player player) {
        ItemStack main = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack off = player.getItemInHand(InteractionHand.OFF_HAND);
        return main != ItemStack.EMPTY && main.getItem() == IPContent.DEBUGITEM.get() || off != ItemStack.EMPTY && off.getItem() == IPContent.DEBUGITEM.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderDebuggingOverlay(RenderGuiLayerEvent.Post event) {
        HitResult rt;
        LocalPlayer player;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && event.getName() == VanillaGuiLayers.DEBUG_OVERLAY && this.isHoldingDebugItem((Player)(player = mc.player)) && (rt = mc.hitResult) != null) {
            switch (rt.getType()) {
                case BLOCK: {
                    BlockHitResult result = (BlockHitResult)rt;
                    Level world = player.level();
                    BlockPos hitPos = result.getBlockPos();
                    BlockState blockState = world.getBlockState(hitPos);
                    if (blockState.getBlock() instanceof EntityBlock) {
                        BlockEntity te = world.getBlockEntity(hitPos);
                        if (te instanceof GasGeneratorTileEntity) {
                            GasGeneratorTileEntity gas = (GasGeneratorTileEntity)te;
                            MutableComponent name = Component.translatable((String)te.getBlockState().getBlock().getDescriptionId()).withStyle(ChatFormatting.GOLD);
                            boolean isActive = !gas.stopSound(null);
                            name.append((Component)Component.literal((String)(isActive ? " (Active)" : " (Inactive)")).withStyle(isActive ? ChatFormatting.GREEN : ChatFormatting.RED));
                            if (world.hasNeighborSignal(gas.getPosition())) {
                                name.append((Component)Component.literal((String)" (Redstoned)").withStyle(ChatFormatting.RED));
                            }
                            debugText.add((Component)name);
                            debugText.addEnergyText((IEnergyStorage)gas.getCapability(Capabilities.EnergyStorage.BLOCK, null));
                            debugText.addTankText((IFluidHandler)gas.getCapability(Capabilities.FluidHandler.BLOCK, null));
                            break;
                        }
                        if (te instanceof IPTileEntityBase) {
                            debugText.translated(te.getBlockState().getBlock().getDescriptionId(), ChatFormatting.GOLD);
                            if (te instanceof AutoLubricatorTileEntity) {
                                AutoLubricatorTileEntity autolube = (AutoLubricatorTileEntity)te;
                                debugText.literal("isSlave", autolube.isSlave ? ChatFormatting.GREEN : ChatFormatting.RED);
                                if (autolube.isSlave) {
                                    autolube = autolube.master();
                                }
                                FluidTank tank = autolube.tank;
                                FluidStack fs = tank.getFluid();
                                debugText.literal("Facing: " + autolube.facing.getName(), new ChatFormatting[0]);
                                debugText.addTankText((IFluidHandler)autolube.tank);
                                break;
                            }
                            if (te instanceof FlarestackTileEntity) {
                                FlarestackTileEntity flare = (FlarestackTileEntity)te;
                                break;
                            }
                            if (te instanceof WellTileEntity) {
                                WellTileEntity well = (WellTileEntity)te;
                                break;
                            }
                            if (!(te instanceof WellPipeTileEntity)) break;
                            WellPipeTileEntity wellPipeTileEntity = (WellPipeTileEntity)te;
                            break;
                        }
                        if (!(te instanceof IMultiblockBE)) break;
                        IMultiblockBE generic = (IMultiblockBE)te;
                        IMultiblockBEHelper mbHelper = generic.getHelper();
                        IMultiblockState mbState = mbHelper.getState();
                        MultiblockRegistration multiblock = mbHelper.getMultiblock();
                        BlockPos tPos = mbHelper.getPositionInMB();
                        debugText.literal("Template XYZ: " + tPos.getX() + ", " + tPos.getY() + ", " + tPos.getZ(), new ChatFormatting[0]);
                        Block block = (Block)multiblock.block().get();
                        MutableComponent name = DebugRenderHandler.toTranslation(block.getDescriptionId(), new Object[0]).withStyle(ChatFormatting.GOLD);
                        List<LubricatedHandler.LubricatedTileInfo> list = LubricatedHandler.lubricatedTiles;
                        synchronized (list) {
                            for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
                                if (!info.pos.equals((Object)tPos)) continue;
                                name.append((Component)DebugRenderHandler.toText(" (Lubricated " + info.ticks + ")").withStyle(ChatFormatting.YELLOW));
                            }
                        }
                        boolean rsState = this.getRedstoneState(generic);
                        if (rsState) {
                            name.append((Component)DebugRenderHandler.toText(" (Redstoned)").withStyle(ChatFormatting.RED));
                        }
                        debugText.add((Component)name);
                        if (mbState instanceof DistillationTowerLogic.State) {
                            DebugRenderHandler.distillationTower(debugText, generic);
                            break;
                        }
                        if (mbState instanceof CokerUnitLogic.State) {
                            DebugRenderHandler.cokerunit(debugText, generic);
                            break;
                        }
                        if (mbState instanceof HydroTreaterLogic.State) {
                            DebugRenderHandler.hydrotreater(debugText, generic);
                            break;
                        }
                        if (mbState instanceof OilTankLogic.State) {
                            DebugRenderHandler.oiltank(debugText, generic);
                            break;
                        }
                        if (!(mbState instanceof DerrickLogic.State)) break;
                        DebugRenderHandler.derrick(debugText, generic);
                        break;
                    }
                    if (!(blockState.getBlock() instanceof RedStoneWireBlock)) break;
                    debugText.literal("Redstone Wire", ChatFormatting.GOLD);
                    debugText.literal("Power: " + String.valueOf(blockState.getValue((Property)RedStoneWireBlock.POWER)), new ChatFormatting[0]);
                    break;
                }
                case ENTITY: {
                    EntityHitResult result = (EntityHitResult)rt;
                    Entity hitPos = result.getEntity();
                    if (!(hitPos instanceof MotorboatEntity)) break;
                    MotorboatEntity boat = (MotorboatEntity)hitPos;
                    MutableComponent name = Component.translatable((String)"item.immersivepetroleum.speedboat").withStyle(ChatFormatting.GOLD).append(" (" + boat.getStringUUID() + ")");
                    debugText.add((Component)name);
                    IFluidTank tank = boat.getTank();
                    MutableComponent literal = Component.literal((String)String.format("%d/%d mB", tank.getFluidAmount(), tank.getCapacity()));
                    if (!tank.getFluid().isEmpty()) {
                        literal.append(" (" + tank.getFluid().getHoverName().getString() + ")");
                    }
                    debugText.add((Component)literal);
                    NonNullList<ItemStack> upgrades = boat.getUpgrades();
                    int i = 0;
                    for (ItemStack upgrade : upgrades) {
                        if (upgrade == ItemStack.EMPTY) {
                            debugText.literal("Upgrade " + ++i + ": Empty", new ChatFormatting[0]);
                            continue;
                        }
                        debugText.literal("Upgrade " + ++i + ": " + upgrade.getHoverName().getString(), new ChatFormatting[0]);
                    }
                    break;
                }
                default: {
                    boolean debug = false;
                    if (!debug) break;
                    ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
                    BlockPos playerPos = MCUtil.getPlayer().blockPosition();
                    RegionPos rLocal = new RegionPos(playerPos);
                    RegionPos r0 = new RegionPos(playerPos, 1, -1);
                    RegionPos r1 = new RegionPos(playerPos, 1, 1);
                    RegionPos r2 = new RegionPos(playerPos, -1, -1);
                    RegionPos r3 = new RegionPos(playerPos, -1, 1);
                    boolean bLocal = storage.getRegionData(rLocal) != null;
                    boolean b0 = storage.getRegionData(r0) != null;
                    boolean b1 = storage.getRegionData(r1) != null;
                    boolean b2 = storage.getRegionData(r2) != null;
                    boolean b3 = storage.getRegionData(r3) != null;
                    debugText.literal(String.format("PlayerXYZ: %d %d %d", playerPos.getX(), playerPos.getY(), playerPos.getZ()), new ChatFormatting[0]);
                    debugText.literal(String.format("LocalXZ: %d %d", rLocal.x(), rLocal.z()), bLocal ? ChatFormatting.GREEN : ChatFormatting.RED);
                    debugText.literal(String.format("XZ: %d %d", r0.x(), r0.z()), b0 ? ChatFormatting.GREEN : ChatFormatting.RED);
                    debugText.literal(String.format("XZ: %d %d", r1.x(), r1.z()), b1 ? ChatFormatting.GREEN : ChatFormatting.RED);
                    debugText.literal(String.format("XZ: %d %d", r2.x(), r2.z()), b2 ? ChatFormatting.GREEN : ChatFormatting.RED);
                    debugText.literal(String.format("XZ: %d %d", r3.x(), r3.z()), b3 ? ChatFormatting.GREEN : ChatFormatting.RED);
                }
            }
            if (!debugText.isEmpty()) {
                Vec3 location = rt.getLocation();
                BlockPos hit = new BlockPos((int)location.x, (int)location.y, (int)location.z);
                debugText.literal(0, "World XYZ: " + hit.getX() + ", " + hit.getY() + ", " + hit.getZ(), new ChatFormatting[0]);
                debugText.render(event.getGuiGraphics());
            }
        }
    }

    private <S extends IMultiblockState> boolean getRedstoneState(IMultiblockBE<S> generic) {
        IMultiblockBEHelper mbHelper = generic.getHelper();
        IMultiblockState mbState = mbHelper.getState();
        MultiblockRegistration multiblock = mbHelper.getMultiblock();
        if (!multiblock.redstoneInputAware()) {
            return false;
        }
        for (MultiblockRegistration.ExtraComponent extraComponent : multiblock.extraComponents()) {
            IMultiblockComponent iMultiblockComponent = extraComponent.component();
            if (!(iMultiblockComponent instanceof RedstoneControl)) continue;
            RedstoneControl rsCtrl = (RedstoneControl)iMultiblockComponent;
            RedstoneControl.RSState rsState = rsCtrl.wrapState((Object)mbState);
            return rsState.isEnabled(mbHelper.getContext());
        }
        return false;
    }

    @SubscribeEvent
    public void renderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            this.reservoirDebuggingRender(event);
        }
    }

    private void reservoirDebuggingRender(RenderLevelStageEvent event) {
        if (ReservoirHandler.getGenerator() == null) {
            return;
        }
        LocalPlayer player = MCUtil.getPlayer();
        ItemStack main = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack off = player.getItemInHand(InteractionHand.OFF_HAND);
        if (main != ItemStack.EMPTY && main.getItem() == IPContent.DEBUGITEM.get() || off != ItemStack.EMPTY && off.getItem() == IPContent.DEBUGITEM.get()) {
            DebugItem.Mode mode = null;
            if (main != ItemStack.EMPTY) {
                mode = DebugItem.getMode(main);
            }
            if (off != ItemStack.EMPTY) {
                mode = DebugItem.getMode(off);
            }
            if (mode == DebugItem.Mode.SEEDBASED_RESERVOIR || mode == DebugItem.Mode.SEEDBASED_RESERVOIR_AREA_TEST) {
                PoseStack matrix = event.getPoseStack();
                Level world = player.getCommandSenderWorld();
                BlockPos playerPos = player.blockPosition();
                matrix.pushPose();
                MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
                Vec3 renderView = MCUtil.getGameRenderer().getMainCamera().getPosition();
                matrix.translate(-renderView.x, -renderView.y, -renderView.z);
                DebugRenderHandler.renderHeatMap(matrix, buffer, playerPos, world);
                DebugRenderHandler.renderReservoirPolygons(matrix, buffer, (Player)player, playerPos);
                buffer.endBatch();
                matrix.popPose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderReservoirPolygons(PoseStack matrix, MultiBufferSource.BufferSource buffer, Player player, BlockPos playerPos) {
        RegionData[] array;
        matrix.pushPose();
        ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
        ResourceKey dimKey = player.getCommandSenderWorld().dimension();
        HashSet islands = new HashSet();
        RegionPos pLocal = new RegionPos(playerPos);
        RegionPos p0 = new RegionPos(playerPos, 1, -1);
        RegionPos p1 = new RegionPos(playerPos, 1, 1);
        RegionPos p2 = new RegionPos(playerPos, -1, -1);
        RegionPos p3 = new RegionPos(playerPos, -1, 1);
        RegionData rLocal = storage.getRegionData(pLocal);
        RegionData r0 = storage.getRegionData(p0);
        RegionData r1 = storage.getRegionData(p1);
        RegionData r2 = storage.getRegionData(p2);
        RegionData r3 = storage.getRegionData(p3);
        for (RegionData rd : array = new RegionData[]{rLocal, r0, r1, r2, r3}) {
            Multimap<ResourceKey<Level>, Reservoir> m;
            if (rd == null) continue;
            Multimap<ResourceKey<Level>, Reservoir> multimap = m = rd.getReservoirList();
            synchronized (multimap) {
                islands.addAll(m.get((Object)dimKey));
            }
        }
        if (!islands.isEmpty()) {
            float y = 128.0625f;
            int radius = 256;
            radius = radius * radius + radius * radius;
            for (Reservoir reservoir : islands) {
                BlockPos center = reservoir.getBoundingBox().getCenter();
                if (!(center.distSqr((Vec3i)playerPos) <= (double)radius)) continue;
                ReservoirBoundingBox bounds = reservoir.getBoundingBox();
                DebugRenderHandler.renderReservoirBoundingBox(matrix, buffer, bounds, y);
                if (reservoir.getPolygon() == null || reservoir.getPolygon().isEmpty()) continue;
                List<ColumnPos> poly = reservoir.getPolygon().getPolygonList();
                DebugRenderHandler.renderPolygon(matrix, buffer, poly, y, center);
            }
        }
        matrix.popPose();
    }

    private static void renderPolygon(PoseStack matrix, MultiBufferSource.BufferSource buffer, List<ColumnPos> poly, float y, BlockPos center) {
        VertexConsumer builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_LINE);
        matrix.pushPose();
        PoseStack.Pose last = matrix.last();
        Matrix4f mat = last.pose();
        int j = poly.size() - 1;
        int i = 0;
        while (i < poly.size()) {
            ColumnPos a = poly.get(j);
            ColumnPos b = poly.get(i);
            float f = (float)i / (float)poly.size();
            builder.addVertex(mat, (float)a.x() + 0.5f, y, (float)a.z() + 0.5f).setColor(f, 0.0f, 1.0f - f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, (float)b.x() + 0.5f, y, (float)b.z() + 0.5f).setColor(f, 0.0f, 1.0f - f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
            j = i++;
        }
        matrix.popPose();
        matrix.pushPose();
        last = matrix.last();
        mat = last.pose();
        builder.addVertex(mat, (float)center.getX() + 0.5f, 128.0f, (float)center.getZ() + 0.5f).setColor(0.0f, 1.0f, 0.0f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, (float)center.getX() + 0.5f, 129.0f, (float)center.getZ() + 0.5f).setColor(0.0f, 1.0f, 0.0f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, (float)center.getX(), 128.5f, (float)center.getZ() + 0.5f).setColor(1.0f, 0.0f, 0.0f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, (float)(center.getX() + 1), 128.5f, (float)center.getZ() + 0.5f).setColor(1.0f, 0.0f, 0.0f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, (float)center.getX() + 0.5f, 128.5f, (float)center.getZ()).setColor(0.0f, 0.0f, 1.0f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, (float)center.getX() + 0.5f, 128.5f, (float)(center.getZ() + 1)).setColor(0.0f, 0.0f, 1.0f, 0.5f).setNormal(last, 0.0f, 1.0f, 0.0f);
        matrix.popPose();
    }

    private static void renderReservoirBoundingBox(PoseStack matrix, MultiBufferSource.BufferSource buffer, ReservoirBoundingBox bounds, float y) {
        matrix.pushPose();
        float minX = (float)bounds.xMin() + 0.5f;
        float minZ = (float)bounds.zMin() + 0.5f;
        float maxX = (float)bounds.xMax() + 0.5f;
        float maxZ = (float)bounds.zMax() + 0.5f;
        VertexConsumer builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_LINE);
        PoseStack.Pose last = matrix.last();
        Matrix4f mat = last.pose();
        builder.addVertex(mat, minX, y, minZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, maxX, y, minZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, minX, y, maxZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, maxX, y, maxZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, minX, y, minZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, minX, y, maxZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, maxX, y, minZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(mat, maxX, y, maxZ).setColor(255, 0, 255, 127).setNormal(last, 0.0f, 1.0f, 0.0f);
        matrix.popPose();
    }

    /*
     * Exception decompiling
     */
    private static void renderHeatMap(PoseStack matrix, MultiBufferSource.BufferSource buffer, BlockPos playerPos, Level world) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement.transformStructuredChildren(AbstractStructuredBlockStatement.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement.transformStructuredChildren(AbstractStructuredBlockStatement.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement.transformStructuredChildren(AbstractStructuredBlockStatement.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement.transformStructuredChildren(AbstractStructuredBlockStatement.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void distillationTower(DebugText debugText, IMultiblockBE<?> multiblockBE) {
        IMultiblockBEHelper master = DebugRenderHandler.masterOf(multiblockBE.getHelper().asType(IPContent.Multiblock.DISTILLATIONTOWER));
        debugText.literal("Input Tank", ChatFormatting.UNDERLINE);
        debugText.addTankText(null, ((DistillationTowerLogic.State)master.getState()).tanks.input());
        debugText.literal("Output Tank", ChatFormatting.UNDERLINE);
        debugText.addTankText(null, ((DistillationTowerLogic.State)master.getState()).tanks.output());
    }

    private static void cokerunit(DebugText debugText, IMultiblockBE<?> multiblockBE) {
        IMultiblockBEHelper master = DebugRenderHandler.masterOf(multiblockBE.getHelper().asType(IPContent.Multiblock.COKERUNIT));
        FluidTankFiltered tank = ((CokerUnitLogic.State)master.getState()).bufferTanks.input();
        FluidStack fs = tank.getFluid();
        debugText.literal("In Buffer: " + fs.getAmount() + "/" + tank.getCapacity() + "mB " + (String)(fs.isEmpty() ? "" : "(" + fs.getHoverName().getString() + ")"), new ChatFormatting[0]);
        tank = ((CokerUnitLogic.State)master.getState()).bufferTanks.output();
        fs = tank.getFluid();
        debugText.literal("Out Buffer: " + fs.getAmount() + "/" + tank.getCapacity() + "mB " + (String)(fs.isEmpty() ? "" : "(" + fs.getHoverName().getString() + ")"), new ChatFormatting[0]);
        for (int i = 0; i < ((CokerUnitLogic.State)master.getState()).chambers.array().length; ++i) {
            CokingChamber chamber = ((CokerUnitLogic.State)master.getState()).chambers.array()[i];
            FluidTankFiltered tank2 = chamber.getTank();
            FluidStack fs2 = tank2.getFluid();
            float completed = chamber.getTotalAmount() > 0 ? 100.0f * ((float)chamber.getOutputAmount() / (float)chamber.getTotalAmount()) : 0.0f;
            debugText.literal("Chamber " + i, ChatFormatting.UNDERLINE, ChatFormatting.AQUA);
            debugText.literal("State: " + chamber.getState().toString(), new ChatFormatting[0]);
            debugText.literal("  Tank: " + fs2.getAmount() + "/" + tank2.getCapacity() + "mB " + (String)(fs2.isEmpty() ? "" : "(" + fs2.getHoverName().getString() + ")"), new ChatFormatting[0]);
            debugText.literal("  Content: " + chamber.getTotalAmount() + " / " + chamber.getCapacity() + " (" + chamber.getInputItem().getHoverName().getString() + ")", new ChatFormatting[0]);
            debugText.literal("  Out: " + chamber.getOutputItem().getHoverName().getString(), new ChatFormatting[0]);
            debugText.literal("  " + Mth.floor((float)completed) + "% Completed. (Raw: " + completed + ")", new ChatFormatting[0]);
        }
    }

    private static void hydrotreater(DebugText debugText, IMultiblockBE<?> multiblockBE) {
        IMultiblockBEHelper master = DebugRenderHandler.masterOf(multiblockBE.getHelper().asType(IPContent.Multiblock.HYDROTREATER));
        IFluidTank[] tanks = ((HydroTreaterLogic.State)master.getState()).getInternalTanks();
        if (tanks != null && tanks.length > 0) {
            for (int i = 0; i < tanks.length; ++i) {
                FluidStack fs = tanks[i].getFluid();
                debugText.literal("Tank " + i + ": " + fs.getAmount() + "/" + tanks[i].getCapacity() + "mB " + (String)(fs.isEmpty() ? "" : "(" + fs.getHoverName().getString() + ")"), new ChatFormatting[0]);
            }
        }
    }

    private static void oiltank(DebugText debugText, IMultiblockBE<?> multiblockBE) {
        BlockPos mbpos = multiblockBE.getHelper().getPositionInMB();
        OilTankLogic.Port port = null;
        for (OilTankLogic.Port p : OilTankLogic.Port.values()) {
            if (!p.matches(mbpos)) continue;
            port = p;
            break;
        }
        IMultiblockBEHelper tank = DebugRenderHandler.masterOf(multiblockBE.getHelper().asType(IPContent.Multiblock.OILTANK));
        if (port != null) {
            OilTankLogic.PortState portState = ((OilTankLogic.State)tank.getState()).portConfig.get((Object)port);
            boolean isInput = portState == OilTankLogic.PortState.INPUT;
            MutableComponent component = DebugRenderHandler.toText("Port: " + port.getSerializedName()).append((Component)DebugRenderHandler.toText(" " + portState.getSerializedName()).withStyle(isInput ? ChatFormatting.AQUA : ChatFormatting.GOLD));
            debugText.add((Component)component);
        }
        debugText.addTankText(((OilTankLogic.State)tank.getState()).tank);
        FluidStack fs = ((OilTankLogic.State)tank.getState()).tank.getFluid();
    }

    private static void derrick(DebugText debugText, IMultiblockBE<?> multiblockBE) {
        IMultiblockBEHelper derrick = DebugRenderHandler.masterOf(multiblockBE.getHelper().asType(IPContent.Multiblock.DERRICK));
        FluidTankFiltered tanks = ((DerrickLogic.State)derrick.getState()).tank;
        FluidStack fs = tanks.getFluid();
        debugText.literal("Tank : " + fs.getAmount() + "/" + tanks.getCapacity() + "mB " + (String)(fs.isEmpty() ? "" : "(" + fs.getHoverName().getString() + ")"), new ChatFormatting[0]);
    }

    @Deprecated(forRemoval=true)
    private static <State extends IMultiblockState, H extends IMultiblockBEHelper<State>> H masterOf(H helper) {
        if (!(helper instanceof IMultiblockBEHelperMaster) && helper.getContext() != null) {
            IMultiblockLevel mbLevel = helper.getContext().getLevel();
            BlockPos masterPos = mbLevel.toAbsolute(helper.getMultiblock().masterPosInMB());
            BlockEntity be = mbLevel.getRawLevel().getBlockEntity(masterPos);
            if (be instanceof MultiblockBlockEntityMaster) {
                MultiblockBlockEntityMaster master = (MultiblockBlockEntityMaster)be;
                return (H)master.getHelper();
            }
        }
        return helper;
    }

    static MutableComponent toText(String string) {
        return Component.literal((String)string);
    }

    static MutableComponent toTranslation(String translationKey, Object ... args) {
        return Component.translatable((String)translationKey, (Object[])args);
    }
}

