/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.render.dyn.DynamicTextureWrapper;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.items.SurveyResultItem;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import org.joml.Matrix4f;

public class SeismicResultRenderer {
    private static final ResourceLocation OVERLAY = ResourceUtils.ip("textures/gui/seismicsurvey_overlay.png");

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        SurveyScan scan;
        DynamicTextureWrapper wrapper;
        ISurveyInfo iSurveyInfo;
        if (event.getItemStack().getItem() instanceof SurveyResultItem && MCUtil.getPlayer().distanceTo((Entity)event.getItemFrameEntity()) < 1000.0f && (iSurveyInfo = ISurveyInfo.from(event.getItemStack())) instanceof SurveyScan && (wrapper = DynamicTextureWrapper.getOrCreate(65, 65, scan = (SurveyScan)iSurveyInfo)) != null) {
            PoseStack matrix = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
            matrix.pushPose();
            int light = event.getPackedLight();
            int rot = event.getItemFrameEntity().getRotation();
            float scale = 0.015384615f;
            matrix.mulPose(Axis.ZP.rotationDegrees(180.0f - (float)(-rot) * 45.0f));
            matrix.translate(-0.5f, -0.5f, -0.00625f);
            matrix.scale(scale, scale, 1.0f);
            matrix.pushPose();
            int a = wrapper.width;
            int b = wrapper.height;
            VertexConsumer builder = buffer.getBuffer(wrapper.renderType);
            Matrix4f mat = matrix.last().pose();
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(light);
            builder.addVertex(mat, 0.0f, (float)b, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(light);
            builder.addVertex(mat, (float)a, (float)b, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(light);
            builder.addVertex(mat, (float)a, 0.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(light);
            matrix.popPose();
            matrix.pushPose();
            int w = 65;
            int h = 65;
            matrix.translate(0.0f, 0.0f, -0.002f);
            builder = buffer.getBuffer(RenderType.text((ResourceLocation)OVERLAY));
            mat = matrix.last().pose();
            builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(light);
            builder.addVertex(mat, 0.0f, 65.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(light);
            builder.addVertex(mat, 65.0f, 65.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(light);
            builder.addVertex(mat, 65.0f, 0.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(light);
            matrix.popPose();
            matrix.popPose();
            buffer.endBatch();
            event.setCanceled(true);
        }
    }
}

