/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import flaxbeard.immersivepetroleum.client.IPShaders;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class IPRenderTypes {
    static final RenderStateShard.TextureStateShard TEXTURE_ACTIVE_TOWER = IPRenderTypes.texture("textures/multiblock/overlay/distillation_tower_active.png");
    static final RenderStateShard.TextureStateShard TEXTURE_ACTIVE_HYDRO = IPRenderTypes.texture("textures/multiblock/overlay/hydrotreater_active.png");
    static final RenderStateShard.TextureStateShard TEXTURE_OIL_TANK = IPRenderTypes.texture("textures/multiblock/oiltank.png");
    static final RenderStateShard.LightmapStateShard LIGHTMAP_ENABLED = new RenderStateShard.LightmapStateShard(true);
    static final RenderStateShard.OverlayStateShard OVERLAY_ENABLED = new RenderStateShard.OverlayStateShard(true);
    static final RenderStateShard.OverlayStateShard OVERLAY_DISABLED = new RenderStateShard.OverlayStateShard(false);
    static final RenderStateShard.DepthTestStateShard DEPTH_ALWAYS = new RenderStateShard.DepthTestStateShard("always", 519);
    static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, RenderSystem::disableBlend);
    static final RenderStateShard.TransparencyStateShard NO_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("no_transparency", RenderSystem::disableBlend, () -> {});
    static final RenderStateShard.ShaderStateShard PROJECTION_SHADER = new RenderStateShard.ShaderStateShard(IPShaders::getProjectionStaticShader);
    static final RenderStateShard.ShaderStateShard LINE_SHADER = new RenderStateShard.ShaderStateShard(IPShaders::getTranslucentLineShader);
    static final RenderStateShard.ShaderStateShard TRANSLUCENT_SHADER = new RenderStateShard.ShaderStateShard(IPShaders::getTranslucentShader);
    static final RenderStateShard.ShaderStateShard TRANSLUCENT_POSTION_COLOR_SHADER = new RenderStateShard.ShaderStateShard(IPShaders::getTranslucentPostionColorShader);
    public static final RenderType PROJECTION;
    public static final RenderType DISTILLATION_TOWER_ACTIVE_OVERLAY;
    public static final RenderType HYDROTREATER_ACTIVE_OVERLAY;
    public static final RenderType OIL_TANK;
    public static final RenderType TRANSLUCENT_LINE;
    public static final RenderType TRANSLUCENT_POSITION_COLOR;
    public static final RenderType RESERVOIR_DEBUGGING_POSITION_COLOR;
    static final Map<String, RenderType> TYPE_CACHE;

    private static RenderType machineExtra(String name, RenderStateShard.TextureStateShard textureStateShard) {
        return RenderType.create((String)IPRenderTypes.typeName(name), (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)textureStateShard).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP_ENABLED).setOverlayState(OVERLAY_DISABLED).createCompositeState(false));
    }

    public static RenderType getEntitySolid(ResourceLocation locationIn) {
        RenderType.CompositeState renderState = RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENTITY_SOLID_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false, false)).setTransparencyState(NO_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(true);
        return RenderType.create((String)"entity_solid", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)renderState);
    }

    public static MultiBufferSource disableLighting(MultiBufferSource in) {
        return type -> {
            RenderType rt = TYPE_CACHE.computeIfAbsent(IPRenderTypes.typeName(String.valueOf(type) + "_no_lighting"), name -> new RenderType((String)name, type.format(), type.mode(), type.bufferSize(), type.affectsCrumbling(), false, () -> ((RenderType)type).setupRenderState(), () -> ((RenderType)type).clearRenderState()){});
            return in.getBuffer(rt);
        };
    }

    private static String typeName(String str) {
        return "immersivepetroleum:" + str;
    }

    private static RenderStateShard.TextureStateShard texture(String path) {
        return new RenderStateShard.TextureStateShard(ResourceUtils.ip(path), false, false);
    }

    static {
        DISTILLATION_TOWER_ACTIVE_OVERLAY = IPRenderTypes.machineExtra("distillation_tower_active_overlay", TEXTURE_ACTIVE_TOWER);
        HYDROTREATER_ACTIVE_OVERLAY = IPRenderTypes.machineExtra("hydrotreater_active_overlay", TEXTURE_ACTIVE_HYDRO);
        OIL_TANK = IPRenderTypes.machineExtra("oil_tank", TEXTURE_OIL_TANK);
        PROJECTION = RenderType.create((String)IPRenderTypes.typeName("projection"), (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x400000, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(PROJECTION_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.TRANSLUCENT_TARGET).setDepthTestState(DEPTH_ALWAYS).createCompositeState(false));
        TRANSLUCENT_LINE = RenderType.create((String)IPRenderTypes.typeName("translucent_line"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(LINE_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(3.5))).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(DEPTH_ALWAYS).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
        RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(3.5))).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setCullState(RenderStateShard.NO_CULL).createCompositeState(false);
        TRANSLUCENT_POSITION_COLOR = RenderType.create((String)IPRenderTypes.typeName("translucent_position_color"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(TRANSLUCENT_POSTION_COLOR_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).createCompositeState(false));
        RESERVOIR_DEBUGGING_POSITION_COLOR = RenderType.create((String)IPRenderTypes.typeName("island_debugging_position_color"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
        TYPE_CACHE = new HashMap<String, RenderType>();
    }
}

