/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.model.ModelMotorboat;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityMotorboatRenderer
extends EntityRenderer<MotorboatEntity> {
    private static final ResourceLocation texture = ResourceUtils.ip("textures/models/boat_motor.png");
    private static final ResourceLocation textureArmor = ResourceUtils.ip("textures/models/boat_motor_armor.png");
    protected final ModelMotorboat modelBoat = new ModelMotorboat();

    public EntityMotorboatRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.shadowRadius = 0.8f;
    }

    public void render(@Nonnull MotorboatEntity boat, float entityYaw, float partialTicks, PoseStack matrix, @Nonnull MultiBufferSource bufferIn, int packedLight) {
        matrix.pushPose();
        matrix.translate(0.0, 0.375, 0.0);
        this.setupRotation(boat, entityYaw, partialTicks, matrix);
        this.modelBoat.setupAnim(boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (boat.isInLava()) {
            matrix.translate(0.0f, -0.24375f, 0.0f);
        }
        this.animatePropellerAssembly(boat, partialTicks);
        this.animatePropeller(boat, partialTicks);
        this.modelBoat.renderToBuffer(matrix, bufferIn.getBuffer(this.modelBoat.renderType(this.getEntityTexture(boat.isFireproof))), packedLight, OverlayTexture.NO_OVERLAY);
        if (boat.hasPaddles) {
            VertexConsumer vbuilder_normal = bufferIn.getBuffer(this.modelBoat.renderType(texture));
            this.modelBoat.paddles[0].render(matrix, vbuilder_normal, packedLight, OverlayTexture.NO_OVERLAY);
            this.modelBoat.paddles[1].render(matrix, vbuilder_normal, packedLight, OverlayTexture.NO_OVERLAY);
        }
        VertexConsumer vbuilder_armored = bufferIn.getBuffer(this.modelBoat.renderType(textureArmor));
        if (boat.hasIcebreaker) {
            this.modelBoat.icebreak.render(matrix, vbuilder_armored, packedLight, OverlayTexture.NO_OVERLAY);
        }
        if (boat.hasRudders) {
            this.modelBoat.ruddersBase.render(matrix, vbuilder_armored, packedLight, OverlayTexture.NO_OVERLAY);
            this.animateRudders(boat, partialTicks);
            this.modelBoat.rudder1.render(matrix, vbuilder_armored, packedLight, OverlayTexture.NO_OVERLAY);
            this.modelBoat.rudder2.render(matrix, vbuilder_armored, packedLight, OverlayTexture.NO_OVERLAY);
        }
        if (boat.hasTank) {
            this.modelBoat.tank.render(matrix, vbuilder_armored, packedLight, OverlayTexture.NO_OVERLAY);
        }
        if (!boat.isUnderWater()) {
            VertexConsumer vbuilder_mask = bufferIn.getBuffer(RenderType.waterMask());
            this.modelBoat.noWaterRenderer().render(matrix, vbuilder_mask, packedLight, OverlayTexture.NO_OVERLAY);
        }
        matrix.popPose();
        super.render((Entity)boat, entityYaw, partialTicks, matrix, bufferIn, packedLight);
    }

    private void animatePropeller(@Nonnull MotorboatEntity boat, float partialTicks) {
        this.modelBoat.propeller.xRot = boat.propellerRotation.rotLerp(partialTicks) * ((float)Math.PI / 180);
    }

    private void animatePropellerAssembly(@Nonnull MotorboatEntity boat, float partialTicks) {
        if (boat.isEmergency()) {
            this.modelBoat.propellerAssembly.yRot = 0.0f;
            return;
        }
        this.modelBoat.propellerAssembly.yRot = 15.0f * boat.propellerAssemblyRotation.lerp(partialTicks) * ((float)Math.PI / 180);
    }

    private void animateRudders(@Nonnull MotorboatEntity boat, float partialTicks) {
        float pr;
        this.modelBoat.rudder1.yRot = pr = 20.0f * boat.propellerAssemblyRotation.lerp(partialTicks) * ((float)Math.PI / 180);
        this.modelBoat.rudder2.yRot = pr;
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull MotorboatEntity entity) {
        return texture;
    }

    public ResourceLocation getEntityTexture(boolean armored) {
        return armored ? textureArmor : texture;
    }

    public void setupRotation(MotorboatEntity boat, float entityYaw, float partialTicks, PoseStack matrix) {
        matrix.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)boat.getHurtTime() - partialTicks;
        float f1 = boat.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrix.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)boat.getHurtDir()));
        }
        if (boat.isBoosting) {
            matrix.mulPose(Axis.XP.rotationDegrees(3.0f));
        }
        matrix.scale(-1.0f, -1.0f, 1.0f);
        matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
    }
}

