/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.api.ApiUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.IPBlockEntityRenderer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.SeismicSurveyTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BlockSeismicSurveyBarrelRenderer
extends IPBlockEntityRenderer<SeismicSurveyTileEntity> {
    public static final ModelResourceLocation BARREL = ResourceUtils.ipModel("block/dyn/seismic_survey_tool_barrel");

    public boolean shouldRenderOffScreen(@Nonnull SeismicSurveyTileEntity pBlockEntity) {
        return true;
    }

    public void render(SeismicSurveyTileEntity te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (te.isSlave || !te.getLevel().hasChunkAt(te.getBlockPos())) {
            return;
        }
        matrix.pushPose();
        double d = (double)te.timer / 10.0;
        matrix.translate(0.0, -0.125 * (1.0 - d), 0.0);
        List quads = MCUtil.getModel(BARREL).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        PoseStack.Pose last = matrix.last();
        VertexConsumer solid = buffer.getBuffer(RenderType.solid());
        for (BakedQuad quad : quads) {
            solid.putBulkData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
        matrix.popPose();
    }
}

