/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.render.IPBlockEntityRenderer;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class BlockAutoLubricatorRenderer
extends IPBlockEntityRenderer<AutoLubricatorTileEntity> {
    public boolean shouldRenderOffScreen(@Nonnull AutoLubricatorTileEntity te) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(@Nonnull AutoLubricatorTileEntity lubricator, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IMultiblockBEHelperMaster<?> mbMaster;
        IMultiblockBE tile;
        LubricatedHandler.ILubricationHandler<?, ?> handler;
        if (lubricator.isSlave) {
            return;
        }
        FluidStack fs = lubricator.tank.getFluid();
        float fluidLevel = 0.0f;
        if (!fs.isEmpty()) {
            fluidLevel = (float)fs.getAmount() / (float)lubricator.tank.getCapacity();
        }
        if (fluidLevel > 0.0f) {
            float height = 16.0f;
            transform.pushPose();
            float scale = 0.0625f;
            transform.translate(0.25, 0.875, 0.25);
            transform.scale(scale, scale, scale);
            VertexConsumer builder = bufferIn.getBuffer(RenderType.solid());
            float h = height * fluidLevel;
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.mulPose(Axis.YP.rotationDegrees(90.0f));
            transform.translate(-7.98, 0.0, 0.0);
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.mulPose(Axis.YP.rotationDegrees(90.0f));
            transform.translate(-7.98, 0.0, 0.0);
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.mulPose(Axis.YP.rotationDegrees(90.0f));
            transform.translate(-7.98, 0.0, 0.0);
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            if (h < height) {
                transform.mulPose(Axis.XP.rotationDegrees(90.0f));
                transform.translate(0.0f, 0.0f, -h);
                GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)8.0f);
            }
            transform.popPose();
        }
        transform.pushPose();
        Level level = lubricator.getLevel();
        BlockPos target = lubricator.getBlockPos().relative(lubricator.getFacing());
        BlockEntity h = level.getBlockEntity(target);
        if (h instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((tile = (IMultiblockBE)h).getHelper())) != null && handler.isPlacedCorrectly(level, lubricator.getBlockPos(), lubricator.getFacing()) && (mbMaster = BlockAutoLubricatorRenderer.getMBMaster(level, tile.getHelper())) != null) {
            handler.renderPipes(lubricator, mbMaster, transform, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        transform.popPose();
    }

    private static IMultiblockBEHelperMaster<?> getMBMaster(Level level, IMultiblockBEHelper<?> helper) {
        BlockPos masterPos;
        BlockEntity be;
        if (!(helper instanceof IMultiblockBEHelperMaster) && helper.getContext() != null && (be = level.getBlockEntity(masterPos = helper.getContext().getLevel().toAbsolute(helper.getMultiblock().masterPosInMB()))) instanceof MultiblockBlockEntityMaster) {
            MultiblockBlockEntityMaster master = (MultiblockBlockEntityMaster)be;
            return master.getHelper();
        }
        return null;
    }
}

