/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.particle.FluidParticleData;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidSpill
extends TextureSheetParticle {
    final double ogMotionX;
    final double ogMotionY;
    final double ogMotionZ;

    protected FluidSpill(Fluid fluid, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.setSize(0.5f, 0.5f);
        this.setLifetime(50);
        this.quadSize = 0.25f;
        this.hasPhysics = false;
        this.yd = motionY;
        this.ogMotionX = motionX;
        this.ogMotionY = motionY;
        this.ogMotionZ = motionZ;
        FluidStack fs = new FluidStack(fluid, 1000);
        IClientFluidTypeExtensions fluidProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation location = fluidProperties.getStillTexture(fs);
        TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(location);
        this.setSprite(sprite);
        int argb = fluidProperties.getTintColor(fs);
        this.alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.rCol = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(argb & 0xFF) / 255.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.98;
            this.yd *= 0.98;
            this.zd *= 0.98;
            if (this.onGround) {
                this.xd *= 0.7;
                this.zd *= 0.7;
            }
            this.hasPhysics = this.yd <= 0.0;
            this.quadSize *= 0.97f;
        }
    }

    public void render(@Nonnull VertexConsumer buffer, @Nonnull Camera renderInfo, float partialTicks) {
        super.render(buffer, renderInfo, partialTicks);
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<FluidParticleData> {
        public Particle createParticle(FluidParticleData type, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FluidSpill(type.getFluid(), world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

