/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.client.particle.IPParticleTypes;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FluidParticleData
implements ParticleOptions {
    public static final MapCodec<FluidParticleData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("fluid").forGetter(FluidParticleData::writeToString)).apply((Applicative)instance, FluidParticleData::new));
    private final Fluid fluid;

    public FluidParticleData(String name) {
        this(RegistryUtils.getFluidFromRegistryName(ResourceLocation.parse((String)name)));
    }

    public FluidParticleData(Fluid fluid) {
        this.fluid = fluid;
    }

    @Nonnull
    public ParticleType<FluidParticleData> getType() {
        return (ParticleType)IPParticleTypes.FLUID_SPILL.get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeUtf(RegistryUtils.getRegistryNameOf(this.fluid).toString());
    }

    @Nonnull
    public String writeToString() {
        return RegistryUtils.getRegistryNameOf(this.fluid).toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Fluid getFluid() {
        return this.fluid;
    }
}

