/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.particle;

import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class FlareFire
extends SimpleAnimatedParticle {
    final double ogMotionY;
    final float red;
    final float green;
    final float blue;
    final float rotation;

    protected FlareFire(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet spriteWithAge) {
        super(world, x, y, z, spriteWithAge, 0.0f);
        this.setSize(0.5f, 0.5f);
        this.setSpriteFromAge(spriteWithAge);
        this.friction = 1.0f;
        this.setColor(1.0f, 1.0f, 1.0f);
        this.setLifetime(60);
        this.quadSize = 0.5f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
        this.ogMotionY = motionY;
        this.rotation = 0.25f * (world.random.nextFloat() - 0.5f);
        this.oRoll = 360.0f * world.random.nextFloat();
        this.roll = this.oRoll + this.rotation * world.random.nextFloat();
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
    }

    public void tick() {
        float f = (float)this.age / (float)this.lifetime;
        Vector3f vec = Wind.getDirection();
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.age == this.lifetime - 36) {
            this.gCol = this.bCol = (float)((double)0.4f * Math.random());
            this.rCol = this.bCol;
        }
        this.setSpriteFromAge(this.sprites);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.oRoll = this.roll;
        this.move(vec.x() * f, this.ogMotionY * (double)(1.0f - f), vec.z() * f);
        this.roll += this.rotation;
    }

    @EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class Wind {
        private static Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        private static long lastGT;
        private static float lastDirection;
        private static float thisDirection;

        public static Vector3f getDirection() {
            return vec;
        }

        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Pre event) {
            ClientLevel world = MCUtil.getLevel();
            if (world == null) {
                return;
            }
            long gameTime = world.getGameTime();
            if (gameTime / 20L != lastGT) {
                lastGT = gameTime / 20L;
                double fGameTime = (double)gameTime / 20.0;
                Random lastRand = new Random(Mth.floor((double)fGameTime));
                Random thisRand = new Random(Mth.ceil((double)fGameTime));
                lastDirection = lastRand.nextFloat() * 360.0f;
                thisDirection = thisRand.nextFloat() * 360.0f;
            }
            double interpDirection = Mth.lerp((float)((float)(gameTime % 20L) / 20.0f), (float)lastDirection, (float)thisDirection);
            float xSpeed = (float)Math.sin(interpDirection) * 0.1f;
            float zSpeed = (float)Math.cos(interpDirection) * 0.1f;
            vec = new Vector3f(xSpeed, 0.0f, zSpeed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@Nonnull SimpleParticleType typeIn, @Nonnull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlareFire(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

