/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelPumpjack
extends IPModel {
    public static final String ID = "pumpjackarm";
    public static final ResourceLocation TEXTURE = ResourceUtils.ip("textures/models/pumpjack_armature.png");
    public ModelPart origin;
    public ModelPart swingy;
    public ModelPart connector;
    public ModelPart arm;
    public ModelPart wellConnector;
    public ModelPart wellConnector2;
    public float ticks = 0.0f;

    public ModelPumpjack() {
        super(IPRenderTypes::getEntitySolid);
    }

    @Override
    public void init() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootDefinition = meshDefinition.getRoot();
        PartDefinition origin_Definition = rootDefinition.addOrReplaceChild("origin", this.singleCube(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        PartDefinition arm_Definition = origin_Definition.addOrReplaceChild("arm", this.singleCube(0, 40, -40.0f, 0.0f, -4.0f, 70.0f, 10.0f, 8.0f), PartPose.offset((float)56.0f, (float)48.0f, (float)24.0f));
        arm_Definition.addOrReplaceChild("head", this.singleCube(30.0f, -15.0f, -5.0f, 12.0f, 30.0f, 10.0f), PartPose.ZERO);
        arm_Definition.addOrReplaceChild("barBack", this.singleCube(138, 0, -35.0f, 3.0f, -11.0f, 4.0f, 4.0f, 22.0f), PartPose.ZERO);
        PartDefinition swingy_Definition = origin_Definition.addOrReplaceChild("swingy", this.singleCube(44, 14, -4.0f, -2.0f, -14.0f, 8.0f, 10.0f, 4.0f), PartPose.offset((float)24.0f, (float)30.0f, (float)30.0f));
        swingy_Definition.addOrReplaceChild("swingy2", this.singleCube(44, 14, -4.0f, -2.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.ZERO);
        swingy_Definition.addOrReplaceChild("counter", this.singleCube(44, 0, -12.0f, 8.0f, -14.0f, 24.0f, 10.0f, 4.0f), PartPose.ZERO);
        swingy_Definition.addOrReplaceChild("counter2", this.singleCube(44, 0, -12.0f, 8.0f, -2.0f, 24.0f, 10.0f, 4.0f), PartPose.ZERO);
        PartDefinition connector_Definition = origin_Definition.addOrReplaceChild("connector", this.singleCube(108, 0, -1.0f, -1.0f, -12.0f, 2.0f, 24.0f, 2.0f), PartPose.ZERO);
        connector_Definition.addOrReplaceChild("connector2", this.singleCube(100, 0, -1.0f, -1.0f, 6.0f, 2.0f, 24.0f, 2.0f), PartPose.ZERO);
        origin_Definition.addOrReplaceChild("wellConnector", this.singleCube(108, 0, -1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.ZERO);
        origin_Definition.addOrReplaceChild("wellConnector2", this.singleCube(108, 0, -1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshDefinition, (int)190, (int)58);
        ModelPart root = layerDefinition.bakeRoot();
        this.origin = root.getChild("origin");
        this.arm = this.origin.getChild("arm");
        this.swingy = this.origin.getChild("swingy");
        this.connector = this.origin.getChild("connector");
        this.wellConnector = this.origin.getChild("wellConnector");
        this.wellConnector2 = this.origin.getChild("wellConnector2");
    }

    @Override
    public void render(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        float zRot;
        this.arm.zRot = (float)Math.toRadians(15.0 * Math.sin(this.ticks / 25.0f));
        this.swingy.zRot = (float)(1.5707963267948966 + (double)(this.ticks / 25.0f));
        float dist = 8.5f;
        float sin = Mth.sin((float)this.swingy.zRot);
        float cos = Mth.cos((float)this.swingy.zRot);
        this.connector.setPos(24.0f - dist * sin, 30.0f + dist * cos, 26.0f);
        if (sin < 0.0f) {
            this.connector.zRot = (float)(1.5707963705062866 + Math.atan(25.0f / (dist * sin)));
        } else if (sin > 0.0f) {
            this.connector.zRot = (float)(4.71238899230957 + Math.atan(25.0f / (dist * sin)));
        }
        float sin2 = Mth.sin((float)this.arm.zRot);
        float cos2 = Mth.cos((float)this.arm.zRot);
        float x = 24.0f - dist * sin;
        float y = 30.0f + dist * cos;
        float w = 33.0f;
        float h = 4.0f;
        float tx = 56.0f + w * -cos2 - h * sin2;
        float ty = 48.0f + w * -sin2 + h * cos2;
        this.connector.setPos(x, y, 26.0f);
        this.connector.zRot = (float)(4.71238899230957 + Math.atan2(ty - y, tx - x));
        this.wellConnector.setPos(88.0f, 16.0f, 24.0f);
        this.wellConnector2.setPos(88.0f, 16.0f, 24.0f);
        float w2 = -34.0f;
        float h2 = -13.0f;
        float x2 = w2 * -cos2 - h2 * sin2;
        float y2 = w2 * -sin2 + h2 * cos2;
        float tx2 = 32.0f;
        float ty2 = -32.0f;
        this.wellConnector.setPos(56.0f + x2, 48.0f + y2, 24.0f);
        this.wellConnector2.setPos(56.0f + x2, 48.0f + y2, 24.0f);
        this.wellConnector.zRot = zRot = (float)(4.71238899230957 + Math.atan2(ty2 - y2, tx2 - x2));
        this.wellConnector2.zRot = zRot;
        double sqrt = Math.sqrt((tx2 - x2) * (tx2 - x2) + (ty2 - y2) * (ty2 - y2));
        if (sqrt <= 16.0) {
            this.wellConnector.visible = true;
            this.wellConnector2.visible = false;
        } else {
            this.wellConnector.visible = true;
            this.wellConnector2.visible = true;
        }
        this.origin.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }
}

