/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.machines;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.client.gui.machines.IPContainerScreen_Derrick;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.gui.DerrickContainer;
import flaxbeard.immersivepetroleum.common.network.MessageDerrick;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class IPContainerScreen_DerrickSettingsScreen
extends Screen {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/derrick_settings.png");
    private final int xSize = 158;
    private final int ySize = 176;
    private int guiLeft;
    private int guiTop;
    private PipeConfig pipeConfig;
    final IPContainerScreen_Derrick derrickScreen;

    public IPContainerScreen_DerrickSettingsScreen(IPContainerScreen_Derrick derrickScreen) {
        super((Component)Component.literal((String)"DerrickSettings"));
        this.derrickScreen = derrickScreen;
    }

    protected void init() {
        IMultiblockBE be;
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        BlockEntity tile = ((DerrickContainer)this.derrickScreen.getMenu()).level.getBlockEntity(((DerrickContainer)this.derrickScreen.getMenu()).pos());
        if (tile instanceof IMultiblockBE && (be = (IMultiblockBE)tile).getHelper().getState() instanceof DerrickLogic.State) {
            this.pipeConfig = new PipeConfig((IMultiblockBEHelper<DerrickLogic.State>)be.getHelper().asType(IPContent.Multiblock.DERRICK), this.guiLeft + 10, this.guiTop + 10, 138, 138, 69, 69, 2);
            this.addRenderableWidget((GuiEventListener)this.pipeConfig);
            int halfSize = this.xSize / 2;
            this.addButton("set", b -> MessageDerrick.sendToServer(be.getHelper().getContext().getLevel().getAbsoluteOrigin(), this.pipeConfig.getGrid()), halfSize - 65, this.ySize - 25, 40, 20);
            this.addButton("reset", b -> this.pipeConfig.reset((IMultiblockBEHelper<DerrickLogic.State>)be.getHelper().asType(IPContent.Multiblock.DERRICK)), halfSize - 20, this.ySize - 25, 40, 20);
            this.addButton("close", b -> this.onClose(), halfSize + 25, this.ySize - 25, 40, 20);
        }
    }

    private void addButton(String name, Button.OnPress onPress, int x, int y, int w, int h) {
        MutableComponent nameText = Component.translatable((String)("gui.immersivepetroleum.derrick.settings.button." + name));
        MutableComponent descText = Component.translatable((String)("gui.immersivepetroleum.derrick.settings.button." + name + ".desc"));
        Button button = Button.builder((Component)nameText, (Button.OnPress)onPress).bounds(this.guiLeft + x, this.guiTop + y, w, h).tooltip(Tooltip.create((Component)descText)).build();
        this.addRenderableWidget((GuiEventListener)button);
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(GUI_TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        if (mouseX >= this.pipeConfig.getX() && mouseX < this.pipeConfig.getX() + this.pipeConfig.getWidth() && mouseY >= this.pipeConfig.getY() && mouseY < this.pipeConfig.getY() + this.pipeConfig.getHeight()) {
            int i;
            IMultiblockBE be;
            int x = (mouseX - this.pipeConfig.getX()) / this.pipeConfig.getGridScale();
            int y = (mouseY - this.pipeConfig.getY()) / this.pipeConfig.getGridScale();
            int px = x - this.pipeConfig.getGrid().getWidth() / 2;
            int py = y - this.pipeConfig.getGrid().getHeight() / 2;
            if (px >= -2 && px <= 2 && py >= -2 && py <= 2) {
                tooltip.add(Component.translatable((String)"gui.immersivepetroleum.derrick.settings.derrickishere"));
            } else {
                MutableComponent d = Component.empty();
                if (py < 0) {
                    d.append((Component)Component.translatable((String)"gui.immersivepetroleum.dirs.north"));
                } else if (py > 0) {
                    d.append((Component)Component.translatable((String)"gui.immersivepetroleum.dirs.south"));
                }
                if (px != 0) {
                    if (py != 0) {
                        d.append((Component)Component.literal((String)"-"));
                    }
                    if (px < 0) {
                        d.append((Component)Component.translatable((String)"gui.immersivepetroleum.dirs.west"));
                    } else if (px > 0) {
                        d.append((Component)Component.translatable((String)"gui.immersivepetroleum.dirs.east"));
                    }
                }
                tooltip.add(d.withStyle(ChatFormatting.UNDERLINE));
            }
            BlockEntity tile = ((DerrickContainer)this.derrickScreen.getMenu()).level.getBlockEntity(((DerrickContainer)this.derrickScreen.getMenu()).pos());
            if (tile instanceof IMultiblockBE && (be = (IMultiblockBE)tile).getHelper().getState() instanceof DerrickLogic.State) {
                ColumnPos tilePos = Utils.toColumnPos(be.getHelper().getPositionInMB());
                tooltip.add(Component.literal((String)String.format(Locale.ENGLISH, "X: %d \u00a77(%d)", tilePos.x() + px, px)));
                tooltip.add(Component.literal((String)String.format(Locale.ENGLISH, "Z: %d \u00a77(%d)", tilePos.z() + py, py)));
            }
            if ((i = this.pipeConfig.getGrid().get(x, y)) > 0) {
                switch (i) {
                    case 1: {
                        tooltip.add(Component.translatable((String)"gui.immersivepetroleum.derrick.settings.pipe.normal"));
                        break;
                    }
                    case 2: {
                        tooltip.add(Component.translatable((String)"gui.immersivepetroleum.derrick.settings.pipe.perforated"));
                        break;
                    }
                    case 3: {
                        tooltip.add(Component.translatable((String)"gui.immersivepetroleum.derrick.settings.pipe.perforated_fixed"));
                    }
                }
            }
            int xa = this.pipeConfig.getX() + x * this.pipeConfig.getGridScale();
            int ya = this.pipeConfig.getY() + y * this.pipeConfig.getGridScale();
            guiGraphics.fill(xa, ya, xa + this.pipeConfig.getGridScale(), ya + this.pipeConfig.getGridScale(), Integer.MAX_VALUE);
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.renderComponentTooltip(this.minecraft.font, tooltip, mouseX, mouseY);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.derrickScreen);
        this.pipeConfig.dispose();
    }

    public void resize(@Nonnull Minecraft minecraft, int width, int height) {
        PipeConfig oldGrid = this.pipeConfig;
        super.resize(minecraft, width, height);
        this.pipeConfig.copyDataFrom(oldGrid);
        oldGrid.dispose();
    }
}

