/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.elements;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.cfg.IPClientConfig;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.Heightmap;
import org.joml.Matrix4f;

public class PipeConfig
extends Button {
    static final Button.OnPress NO_ACTION = b -> {};
    public static final int EMPTY = 0;
    public static final int PIPE_NORMAL = 1;
    public static final int PIPE_PERFORATED = 2;
    public static final int PIPE_PERFORATED_FIXED = 3;
    private final int dynTextureWidth;
    private final int dynTextureHeight;
    private final DynamicTexture gridTexture;
    private final RenderType gridTextureRenderType;
    private final ResourceLocation dynTextureRL;
    private final int pipeNormalColor;
    private final int pipePerforatedColor;
    private final int pipePerforatedFixedColor;
    protected Grid grid;
    protected ColumnPos tilePos;
    protected int gridWidthScaled;
    protected int gridHeightScaled;
    protected int gridScale;
    int[] pipeCountArray = new int[4];

    public PipeConfig(IMultiblockBEHelper<DerrickLogic.State> tile, int x, int y, int width, int height, int gridWidth, int gridHeight, int gridScale) {
        super(x, y, width, height, (Component)Component.empty(), NO_ACTION, DEFAULT_NARRATION);
        this.tilePos = Utils.toColumnPos(tile.getContext().getLevel().getAbsoluteOrigin());
        this.grid = new Grid(gridWidth, gridHeight);
        this.copyGridFrom(((DerrickLogic.State)tile.getState()).gridStorage);
        this.gridWidthScaled = gridWidth * gridScale;
        this.gridHeightScaled = gridHeight * gridScale;
        this.gridScale = Mth.clamp((int)gridScale, (int)1, (int)Integer.MAX_VALUE);
        this.dynTextureWidth = gridWidth;
        this.dynTextureHeight = gridHeight;
        this.gridTexture = new DynamicTexture(this.dynTextureWidth, this.dynTextureHeight, true);
        this.dynTextureRL = ResourceUtils.ip("pipegrid/" + ((Object)((Object)this)).hashCode());
        MCUtil.getTextureManager().register(this.dynTextureRL, (AbstractTexture)this.gridTexture);
        this.gridTextureRenderType = RenderType.text((ResourceLocation)this.dynTextureRL);
        this.pipeNormalColor = IPClientConfig.GRID_COLORS.getPipeColorNormal();
        this.pipePerforatedColor = IPClientConfig.GRID_COLORS.getPipeColorPerforated();
        this.pipePerforatedFixedColor = IPClientConfig.GRID_COLORS.getPipeColorPerforatedFixed();
        this.updateTexture();
    }

    public void reset(IMultiblockBEHelper<DerrickLogic.State> tile) {
        this.copyGridFrom(((DerrickLogic.State)tile.getState()).gridStorage);
        this.updateTexture();
    }

    private void copyGridFrom(Grid grid) {
        if (grid != null && grid.width == this.grid.width && grid.height == this.grid.height) {
            System.arraycopy(grid.array, 0, this.grid.array, 0, this.grid.array.length);
            this.grid.changed = true;
        }
    }

    public Grid getGrid() {
        return this.grid;
    }

    public int getGridScale() {
        return this.gridScale;
    }

    public void dispose() {
        this.gridTexture.close();
        MCUtil.getTextureManager().release(this.dynTextureRL);
    }

    public void updateTexture() {
        NativeImage image = this.gridTexture.getPixels();
        int texCenterX = this.grid.width / this.gridScale;
        int texCenterY = this.grid.height / this.gridScale;
        int x2 = this.grid.width / 2;
        int y2 = this.grid.height / 2;
        int x4 = this.grid.width / 4;
        int y4 = this.grid.height / 4;
        ClientLevel world = MCUtil.getLevel();
        int a = 0;
        for (int gy = 0; gy < this.grid.getHeight(); ++gy) {
            int gx = 0;
            while (gx < this.grid.getWidth()) {
                int color = switch (this.grid.get(gx, gy)) {
                    case 0 -> {
                        int tmp = 0;
                        if (gx < texCenterX - 2 || gx > texCenterX + 2 || gy < texCenterY - 2 || gy > texCenterY + 2) {
                            float f;
                            int px = gx - x2;
                            int py = gy - y2;
                            ColumnPos c = new ColumnPos(this.tilePos.x() + px, this.tilePos.z() + py);
                            int y = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos(c.x(), 0, c.z())).getY() - 1;
                            BlockPos p = new BlockPos(c.x(), y, c.z());
                            float v0 = f = a % 2 == 0 ? 0.55f : 0.6f;
                            if (gx % x4 == 0 || gy % y4 == 0) {
                                f -= 0.15f;
                            }
                            tmp = world.getBlockState((BlockPos)p).getMapColor((BlockGetter)world, (BlockPos)p).col;
                            int r = (int)((float)(tmp >> 16 & 0xFF) * f);
                            int g = (int)((float)(tmp >> 8 & 0xFF) * f);
                            int b = (int)((float)(tmp >> 0 & 0xFF) * f);
                            tmp = r << 16 | g << 8 | b;
                        }
                        yield tmp;
                    }
                    case 1 -> this.pipeNormalColor;
                    case 2 -> this.pipePerforatedColor;
                    case 3 -> this.pipePerforatedFixedColor;
                    default -> 0;
                };
                image.setPixelRGBA(gx, gy, PipeConfig.toABGR(color));
                ++gx;
                ++a;
            }
        }
        this.gridTexture.upload();
    }

    public void renderWidget(GuiGraphics gui, int mx, int my, float partialTicks) {
        MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
        VertexConsumer builder = buffer.getBuffer(this.gridTextureRenderType);
        gui.pose().pushPose();
        gui.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        Matrix4f mat = gui.pose().last().pose();
        int x = this.grid.width * this.gridScale;
        int y = this.grid.height * this.gridScale;
        builder.addVertex(mat, 0.0f, (float)y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(mat, (float)x, (float)y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setLight(0xF000F0);
        builder.addVertex(mat, (float)x, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setLight(0xF000F0);
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setLight(0xF000F0);
        gui.pose().popPose();
        buffer.endBatch();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.clicked(mouseX, mouseY))) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.onGridClick((int)(mouseX - (double)this.getX()) / this.gridScale, (int)(mouseY - (double)this.getY()) / this.gridScale, button);
            return true;
        }
        return false;
    }

    protected void onGridClick(int x, int y, int button) {
        int type = this.grid.get(x, y);
        if ((type == 1 || type == 2) && type != 3) {
            int[] array = this.getPipeCount();
            if (type == 1 && array[2] < 2) {
                this.grid.set(x, y, 2);
            } else {
                this.grid.set(x, y, 1);
            }
        } else {
            this.grid.clearGrid();
            this.grid.drawLine(this.grid.getWidth() / 2, this.grid.getHeight() / 2, x, y, 1);
            this.grid.set(this.grid.getWidth() / 2, this.grid.getHeight() / 2, 3);
            this.grid.set(Mth.clamp((int)x, (int)0, (int)(this.grid.getWidth() - 1)), Mth.clamp((int)y, (int)0, (int)(this.grid.getHeight() - 1)), 3);
        }
        this.updateTexture();
    }

    private int[] getPipeCount() {
        if (this.grid.changed) {
            this.pipeCountArray = new int[4];
            for (int i = 0; i < this.grid.size(); ++i) {
                int type;
                int n = type = this.grid.get(i);
                this.pipeCountArray[n] = this.pipeCountArray[n] + 1;
            }
            this.grid.changed = false;
        }
        return this.pipeCountArray;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public PipeConfig copyDataFrom(PipeConfig other) {
        if (other != null) {
            this.gridScale = other.gridScale;
            this.grid = other.grid;
            this.updateTexture();
        }
        return this;
    }

    private static int toABGR(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    public static class Grid {
        private boolean changed;
        private int width;
        private int height;
        private byte[] array;

        public Grid(int width, int height) {
            this.width = width;
            this.height = height;
            this.array = new byte[width * height];
        }

        Grid() {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int size() {
            return this.array.length;
        }

        public void set(int x, int y, int value) {
            this.set(this.index(x, y), value);
        }

        public void set(int index, int value) {
            if (index >= 0 && index < this.array.length && this.array[index] != value) {
                this.array[index] = (byte)(value & 0xFF);
                this.changed = true;
            }
        }

        public int get(int x, int y) {
            return this.get(this.index(x, y));
        }

        public int get(int index) {
            if (index >= 0 && index < this.array.length) {
                return this.array[index] & 0xFF;
            }
            return 0;
        }

        public void clearGrid() {
            for (int i = 0; i < this.size(); ++i) {
                this.array[i] = 0;
            }
        }

        public void drawLine(int xa, int ya, int xb, int yb, int value) {
            xa = Mth.clamp((int)xa, (int)0, (int)(this.width - 1));
            xb = Mth.clamp((int)xb, (int)0, (int)(this.width - 1));
            ya = Mth.clamp((int)ya, (int)0, (int)(this.height - 1));
            yb = Mth.clamp((int)yb, (int)0, (int)(this.height - 1));
            int dx = xb - xa;
            int dy = yb - ya;
            int length = Math.max(Math.abs(dx), Math.abs(dy));
            float tx = (float)dx / (float)length;
            float ty = (float)dy / (float)length;
            float x = xa;
            float y = ya;
            int lx = -1;
            int ly = -1;
            for (int i = 1; i <= length; ++i) {
                int cx = Math.round(x);
                int cy = Math.round(y);
                if (lx != cx || ly != cy) {
                    this.set(cx, cy, value);
                    lx = cx;
                    ly = cy;
                }
                x += tx;
                y += ty;
            }
        }

        int index(int x, int y) {
            return this.width * y + x;
        }

        public CompoundTag toCompound() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("width", this.width);
            nbt.putInt("height", this.height);
            nbt.putByteArray("grid", this.array);
            return nbt;
        }

        public static Grid fromCompound(CompoundTag nbt) {
            Grid grid = new Grid();
            grid.width = nbt.getInt("width");
            grid.height = nbt.getInt("height");
            grid.array = nbt.getByteArray("grid");
            if (grid.array.length != grid.width * grid.height) {
                throw new IllegalStateException("Grid width and height don't match array.");
            }
            return grid;
        }
    }
}

