/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import flaxbeard.immersivepetroleum.client.gui.displays.Display;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class IPContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C> {
    protected final ResourceLocation background;
    private final List<Display> displays = new ArrayList<Display>();

    public IPContainerScreen(C container, Inventory inventory, Component title, ResourceLocation background) {
        super(container, inventory, title);
        this.background = background;
    }

    public IPContainerScreen(C container, Inventory inventory, Component title, ResourceLocation background, int backgroundWidth, int backgroundHeight) {
        super(container, inventory, title);
        this.background = background;
        this.imageWidth = backgroundWidth;
        this.imageHeight = backgroundHeight;
    }

    protected void init() {
        super.init();
        this.displays.clear();
    }

    protected void addDisplay(Display display) {
        this.displays.add(display);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        ArrayList tooltip = new ArrayList();
        if (!this.displays.isEmpty()) {
            this.displays.forEach(d -> d.fillTooltip(guiGraphics, mouseX, mouseY, tooltip));
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(this.background, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (!this.displays.isEmpty()) {
            this.displays.forEach(d -> d.draw(guiGraphics, mouseX, mouseY));
        }
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

