/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.render.RenderUtils;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.wooden.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class LubricatorGhostRenderer {
    private final HashSet<BlockPos> previousMasters = new HashSet(256);
    private final RenderType renderType = RenderType.translucent();
    private final Minecraft minecraft;

    public LubricatorGhostRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void render(PoseStack matrix) {
        boolean off;
        if (this.minecraft.player == null) {
            return;
        }
        ItemStack mainItem = this.minecraft.player.getMainHandItem();
        ItemStack secondItem = this.minecraft.player.getOffhandItem();
        boolean main = !mainItem.isEmpty() && mainItem.getItem() == ((AutoLubricatorBlock)IPContent.Blocks.AUTO_LUBRICATOR.get()).asItem();
        boolean bl = off = !secondItem.isEmpty() && secondItem.getItem() == ((AutoLubricatorBlock)IPContent.Blocks.AUTO_LUBRICATOR.get()).asItem();
        if (main || off) {
            matrix.pushPose();
            BlockRenderDispatcher blockDispatcher = this.minecraft.getBlockRenderer();
            MultiBufferSource.BufferSource buffer = RenderUtils.immediate();
            Vec3 renderView = MCUtil.getGameRenderer().getMainCamera().getPosition();
            matrix.translate(-renderView.x, -renderView.y, -renderView.z);
            Level level = this.minecraft.player.level();
            BlockPos base = this.minecraft.player.blockPosition();
            int range = 16;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    for (int y = -range; y <= range; ++y) {
                        BlockState targetState;
                        LubricatedHandler.ILubricationHandler.GhostInfo ghost;
                        LubricatedHandler.ILubricationHandler<?, ?> handler;
                        BlockPos masterPos;
                        IMultiblockBE multiblockBE;
                        IMultiblockBEHelperMaster<?> masterHelper;
                        BlockPos pos = base.offset(x, y, z);
                        BlockEntity te = level.getBlockEntity(pos);
                        if (!(te instanceof IMultiblockBE) || (masterHelper = Utils.getMultiblockMasterHelper(level, (multiblockBE = (IMultiblockBE)te).getHelper())) == null || this.previousMasters.contains(masterPos = masterHelper.getContext().getLevel().toAbsolute(masterHelper.getMultiblock().masterPosInMB())) || (handler = LubricatedHandler.getHandlerForTile(masterHelper)) == null || (ghost = handler.getGhostBlockPosition(level, masterHelper)) == null || !(targetState = level.getBlockState(ghost.position())).is(BlockTags.REPLACEABLE) || !level.getBlockState(ghost.position().above()).is(BlockTags.REPLACEABLE)) continue;
                        this.previousMasters.add(masterPos);
                        VertexConsumer vBuilder = buffer.getBuffer(this.renderType);
                        matrix.pushPose();
                        matrix.translate((float)ghost.position().getX(), (float)ghost.position().getY(), (float)ghost.position().getZ());
                        BlockState state = (BlockState)((AutoLubricatorBlock)IPContent.Blocks.AUTO_LUBRICATOR.get()).defaultBlockState().setValue((Property)AutoLubricatorBlock.FACING, (Comparable)ghost.facing());
                        BakedModel model = blockDispatcher.getBlockModel(state);
                        blockDispatcher.getModelRenderer().renderModel(matrix.last(), vBuilder, null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, this.renderType);
                        matrix.popPose();
                        buffer.endBatch();
                    }
                }
            }
            matrix.popPose();
        }
        if (!this.previousMasters.isEmpty()) {
            this.previousMasters.clear();
        }
    }
}

