/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import flaxbeard.immersivepetroleum.client.render.BlockAutoLubricatorRenderer;
import flaxbeard.immersivepetroleum.client.render.BlockSeismicSurveyBarrelRenderer;
import flaxbeard.immersivepetroleum.client.render.EntityMotorboatRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockDerrickRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockDistillationTowerRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockHydrotreaterRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockOilTankRenderer;
import flaxbeard.immersivepetroleum.client.render.multiblock.MultiblockPumpjackRenderer;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.entity.IPEntityTypes;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModBusEventHandlers {
    @SubscribeEvent
    public static void registerRenders(EntityRenderersEvent.RegisterRenderers ev) {
        ClientModBusEventHandlers.registerBERenderNoContext(ev, IPContent.Multiblock.DERRICK.masterBE(), MultiblockDerrickRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(ev, IPContent.Multiblock.PUMPJACK.masterBE(), MultiblockPumpjackRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(ev, IPContent.Multiblock.DISTILLATIONTOWER.masterBE(), MultiblockDistillationTowerRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(ev, IPContent.Multiblock.HYDROTREATER.masterBE(), MultiblockHydrotreaterRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(ev, IPContent.Multiblock.OILTANK.masterBE(), MultiblockOilTankRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, (BlockEntityType)IPTileTypes.AUTOLUBE.get(), BlockAutoLubricatorRenderer::new);
        ClientModBusEventHandlers.registerBERender(ev, (BlockEntityType)IPTileTypes.SEISMIC_SURVEY.get(), BlockSeismicSurveyBarrelRenderer::new);
        ClientModBusEventHandlers.registerEntityRenderingHandler(ev, IPEntityTypes.MOTORBOAT, EntityMotorboatRenderer::new);
        ClientModBusEventHandlers.registerEntityRenderingHandler(ev, IPEntityTypes.MOLOTOV, ThrownItemRenderer::new);
    }

    private static <T extends BlockEntity> void registerBERenderNoContext(EntityRenderersEvent.RegisterRenderers event, Supplier<BlockEntityType<? extends T>> type, Supplier<BlockEntityRenderer<T>> render) {
        ClientModBusEventHandlers.registerBERenderNoContext(event, type.get(), render);
    }

    private static <T extends BlockEntity> void registerBERenderNoContext(EntityRenderersEvent.RegisterRenderers event, BlockEntityType<? extends T> type, Supplier<BlockEntityRenderer<T>> render) {
        event.registerBlockEntityRenderer(type, $ -> (BlockEntityRenderer)render.get());
    }

    private static <T extends BlockEntity> void registerBERender(EntityRenderersEvent.RegisterRenderers ev, BlockEntityType<T> type, Supplier<BlockEntityRenderer<T>> factory) {
        ev.registerBlockEntityRenderer(type, ctx -> (BlockEntityRenderer)factory.get());
    }

    private static <T extends Entity, T2 extends T> void registerEntityRenderingHandler(EntityRenderersEvent.RegisterRenderers ev, Supplier<EntityType<T2>> type, EntityRendererProvider<T> renderer) {
        ev.registerEntityRenderer(type.get(), renderer);
    }
}

