/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import java.util.Objects;
import net.minecraft.core.BlockPos;

public class ReservoirBoundingBox {
    final int xMin;
    final int zMin;
    final int xMax;
    final int zMax;
    final BlockPos center;

    public ReservoirBoundingBox(int xMin, int zMin, int xMax, int zMax) {
        this.xMin = xMin;
        this.zMin = zMin;
        this.xMax = xMax;
        this.zMax = zMax;
        this.center = new BlockPos((this.xMin + this.xMax) / 2, 0, (this.zMin + this.zMax) / 2);
    }

    public int xMin() {
        return this.xMin;
    }

    public int xMax() {
        return this.xMax;
    }

    public int zMin() {
        return this.zMin;
    }

    public int zMax() {
        return this.zMax;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.getX(), pos.getZ());
    }

    public boolean contains(int x, int z) {
        return x >= this.xMin && x <= this.xMax && z >= this.zMin && z <= this.zMax;
    }

    public int hashCode() {
        return Objects.hash(this.xMax, this.zMax, this.xMin, this.zMin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReservoirBoundingBox)) {
            return false;
        }
        ReservoirBoundingBox other = (ReservoirBoundingBox)obj;
        return this.xMax == other.xMax && this.zMax == other.zMax && this.xMin == other.xMin && this.zMin == other.zMin;
    }

    public String toString() {
        return String.format("%s [xMin = %d, zMin = %d, xMax = %d, zMax = %d]", this.getClass().getSimpleName(), this.xMin, this.zMin, this.xMax, this.zMax);
    }
}

