/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import flaxbeard.immersivepetroleum.api.reservoir.IReservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirBoundingBox;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirPolygon;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionData;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class Reservoir
implements IReservoir {
    public static final int MIN_MBPT = 15;
    public static final int MAX_MBPT = 2500;
    public static final long MAX_AMOUNT = 0xFFFFFFFFL;
    private RegionData regionData;
    private RecipeHolder<ReservoirType> type;
    private final ReservoirPolygon polygon;
    private long amount;
    private long capacity;
    private long lastEquilibriumTick = -1L;

    public Reservoir(@Nonnull ReservoirPolygon polygon, @Nonnull RecipeHolder<ReservoirType> type, long amount) {
        this(polygon, type, amount, amount);
    }

    Reservoir(@Nonnull ReservoirPolygon polygon, @Nonnull RecipeHolder<ReservoirType> type, long capacity, long amount) {
        this.type = Objects.requireNonNull(type);
        this.polygon = Objects.requireNonNull(polygon);
        this.capacity = capacity;
        this.amount = amount;
    }

    public void setRegion(RegionData data) {
        if (this.regionData == null) {
            this.regionData = data;
        }
    }

    public Reservoir setAmountAndCapacity(long amount, long capacity) {
        this.setCapacity(capacity);
        this.setAmount(amount);
        return this;
    }

    public Reservoir setAmount(long amount) {
        this.amount = Reservoir.clamp(amount, 0L, this.capacity);
        return this;
    }

    public Reservoir setCapacity(long capacity) {
        this.capacity = Reservoir.clamp(capacity, 0L, 0xFFFFFFFFL);
        return this;
    }

    public static long clamp(long num, long min, long max) {
        return Math.max(min, Math.min(max, num));
    }

    public Reservoir setReservoirType(@Nonnull RecipeHolder<ReservoirType> type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.amount <= 0L;
    }

    @Override
    public void setDirty() {
        if (this.regionData != null) {
            this.regionData.setDirty();
        }
    }

    @Override
    @Nonnull
    public RecipeHolder<ReservoirType> getType() {
        return this.type;
    }

    @Override
    public Fluid getFluid() {
        return ((ReservoirType)this.type.value()).getFluid();
    }

    @Override
    public ReservoirBoundingBox getBoundingBox() {
        return this.polygon.getBoundingBox();
    }

    @Override
    public ReservoirPolygon getPolygon() {
        return this.polygon;
    }

    public boolean belowHydrostaticEquilibrium(@Nonnull Level level) {
        return ((ReservoirType)this.type.value()).residual > 0 && this.amount <= (long)((ReservoirType)this.type.value()).equilibrium && this.lastEquilibriumTick != level.getGameTime();
    }

    public void equalizeHydrostaticPressure(@Nonnull Level level) {
        if (this.amount <= (long)((ReservoirType)this.type.value()).equilibrium && this.lastEquilibriumTick != level.getGameTime()) {
            this.lastEquilibriumTick = level.getGameTime();
            this.amount += (long)((ReservoirType)this.type.value()).residual;
        }
    }

    @Override
    public int extract(int amount, IFluidHandler.FluidAction fluidAction) {
        if (this.isEmpty()) {
            return 0;
        }
        int extracted = (int)Math.min((long)amount, this.amount);
        if (fluidAction == IFluidHandler.FluidAction.EXECUTE) {
            this.amount -= (long)extracted;
            this.setDirty();
        }
        return extracted;
    }

    @Override
    public int extractWithPressure(@Nonnull Level world, int x, int z) {
        float pressure = this.getPressure(world, x, z);
        if ((double)pressure > 0.0 && this.amount > 0L) {
            int flow = (int)Math.min((long)Reservoir.getFlow(pressure), this.amount);
            this.amount -= (long)flow;
            this.setDirty();
            return flow;
        }
        return 0;
    }

    public int getFlowFromPressure(@Nonnull Level level, BlockPos pos) {
        float pressure = this.getPressure(level, pos.getX(), pos.getZ());
        return Reservoir.getFlow(pressure);
    }

    public static int getFlow(float pressure) {
        return 15 + (int)Math.floor(2485.0f * Mth.clamp((float)pressure, (float)0.0f, (float)1.0f));
    }

    public float getPressure(@Nonnull Level level, int x, int z) {
        double half;
        double alt;
        double noise = ReservoirHandler.getValueOf(level, x, z);
        if (noise > 0.0 && (alt = (double)this.amount - (half = (double)this.capacity * 0.5)) > 0.0) {
            double pre = alt / half;
            return (float)(pre * noise);
        }
        return 0.0f;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("reservoir", this.type.id().toString());
        nbt.putInt("amount", (int)(this.getAmount() & 0xFFFFFFFFL));
        nbt.putInt("capacity", (int)(this.getCapacity() & 0xFFFFFFFFL));
        nbt.put("polygon", (Tag)this.polygon.writeToNBT());
        return nbt;
    }

    public static Reservoir readFromNBT(CompoundTag nbt) {
        try {
            RecipeHolder<ReservoirType> type = ReservoirType.map.get(ResourceLocation.parse((String)nbt.getString("reservoir")));
            if (type != null) {
                long amount = (long)nbt.getInt("amount") & 0xFFFFFFFFL;
                long capacity = (long)nbt.getInt("capacity") & 0xFFFFFFFFL;
                ReservoirPolygon polygon = ReservoirPolygon.fromNBT(nbt.getCompound("polygon"));
                return new Reservoir(polygon, type, capacity, amount);
            }
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
        return null;
    }
}

