/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.energy;

import flaxbeard.immersivepetroleum.common.cfg.ConfigUtils;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FuelHandler {
    protected static final Logger log = LogManager.getLogger((String)"immersivepetroleum/FuelHandler");
    static final Map<ResourceLocation, Values> portablegen = new HashMap<ResourceLocation, Values>();
    static final Map<ResourceLocation, Integer> motorboatAmountTick = new HashMap<ResourceLocation, Integer>();

    public static void registerPortableGeneratorFuel(Fluid fuel, int fluxPerTick, int mbPerTick) {
        if (fuel == null) {
            return;
        }
        FuelHandler.registerPortableGeneratorFuel(RegistryUtils.getRegistryNameOf(fuel), mbPerTick, fluxPerTick);
    }

    public static void registerMotorboatFuel(Fluid fuel, int mbPerTick) {
        if (fuel == null) {
            return;
        }
        FuelHandler.registerMotorboatFuel(RegistryUtils.getRegistryNameOf(fuel), mbPerTick);
    }

    public static void registerPortableGeneratorFuel(ResourceLocation fuelRL, int fluxPerTick, int mbPerTick) {
        if (fuelRL == null || fuelRL.toString().isEmpty()) {
            return;
        }
        portablegen.put(fuelRL, new Values(fluxPerTick, mbPerTick));
        log.info("Added {} as Portable Generator Fuel. ({}RF/t {}mB/t)", (Object)fuelRL, (Object)fluxPerTick, (Object)mbPerTick);
    }

    public static void registerMotorboatFuel(ResourceLocation fuelRL, int mbPerTick) {
        if (fuelRL == null || fuelRL.toString().isEmpty()) {
            return;
        }
        motorboatAmountTick.put(fuelRL, mbPerTick);
        log.info("Added {} as Motorboat Fuel. ({} mB/t)", (Object)fuelRL, (Object)mbPerTick);
    }

    public static boolean isValidBoatFuel(Fluid fuel) {
        return fuel != null && motorboatAmountTick.containsKey(RegistryUtils.getRegistryNameOf(fuel));
    }

    public static boolean isValidFuel(Fluid fuel) {
        return fuel != null && portablegen.containsKey(RegistryUtils.getRegistryNameOf(fuel));
    }

    public static int getBoatFuelUse(Fluid fuel) {
        if (!FuelHandler.isValidBoatFuel(fuel)) {
            return 0;
        }
        return motorboatAmountTick.get(RegistryUtils.getRegistryNameOf(fuel));
    }

    public static int getGeneratorFuelUse(Fluid fuel) {
        if (!FuelHandler.isValidFuel(fuel)) {
            return 0;
        }
        return FuelHandler.portablegen.get((Object)RegistryUtils.getRegistryNameOf((Fluid)fuel)).mBPerConsume;
    }

    public static int getFluxGeneratedPerTick(Fluid fuel) {
        if (!FuelHandler.isValidFuel(fuel)) {
            return 0;
        }
        return FuelHandler.portablegen.get((Object)RegistryUtils.getRegistryNameOf((Fluid)fuel)).fluxPerTick;
    }

    public static void onConfigReload(ModConfigEvent ev) {
        if (ev.getConfig().getSpec() != IPServerConfig.ALL) {
            return;
        }
        portablegen.clear();
        motorboatAmountTick.clear();
        ConfigUtils.addGeneratorFuel((List)IPServerConfig.GENERATION.fuels.get());
        ConfigUtils.addBoatFuel((List)IPServerConfig.MISCELLANEOUS.boat_fuels.get());
    }

    private record Values(int fluxPerTick, int mBPerConsume) {
    }
}

