/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class LubricantHandler {
    static final Set<Pair<TagKey<Fluid>, Integer>> lubricants = new HashSet<Pair<TagKey<Fluid>, Integer>>();

    public static void register(@Nonnull TagKey<Fluid> fluid, int amount) {
        if (lubricants.stream().noneMatch(pair -> pair.getLeft() == fluid)) {
            lubricants.add((Pair<TagKey<Fluid>, Integer>)Pair.of(fluid, (Object)amount));
        }
    }

    public static int getLubeAmount(@Nonnull FluidStack toCheck) {
        return LubricantHandler.getLubeAmount(toCheck.getFluid());
    }

    public static int getLubeAmount(@Nonnull Fluid toCheck) {
        for (Map.Entry entry : lubricants) {
            if (!toCheck.is((TagKey)entry.getKey())) continue;
            return (Integer)entry.getValue();
        }
        return 0;
    }

    public static boolean isValidLube(@Nonnull FluidStack toCheck) {
        return LubricantHandler.isValidLube(toCheck.getFluid());
    }

    public static boolean isValidLube(@Nonnull Fluid toCheck) {
        return lubricants.stream().anyMatch(pair -> toCheck.is((TagKey)pair.getKey()));
    }
}

