/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class HighPressureRefineryRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, RecipeHolder<HighPressureRefineryRecipe>> recipes = new HashMap<ResourceLocation, RecipeHolder<HighPressureRefineryRecipe>>();
    private static final RandomSource RANDOM = RandomSource.create();
    private final FluidStack output;
    @Nullable
    private final StackWithChance outputItem;
    private final SizedFluidIngredient inputFluid;
    @Nullable
    private final SizedFluidIngredient inputFluidSecondary;

    public static RecipeHolder<HighPressureRefineryRecipe> findRecipe(@Nonnull FluidStack input, @Nonnull FluidStack secondary) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(secondary);
        for (RecipeHolder<HighPressureRefineryRecipe> holder : recipes.values()) {
            HighPressureRefineryRecipe recipe = (HighPressureRefineryRecipe)holder.value();
            if (!(secondary.isEmpty() ? recipe.inputFluidSecondary == null && recipe.inputFluid != null && recipe.inputFluid.test(input) : recipe.inputFluid != null && recipe.inputFluid.test(input) && recipe.inputFluidSecondary != null && recipe.inputFluidSecondary.test(secondary))) continue;
            return holder;
        }
        return null;
    }

    public static boolean hasRecipeWithInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (RecipeHolder<HighPressureRefineryRecipe> holder : recipes.values()) {
                HighPressureRefineryRecipe recipe = (HighPressureRefineryRecipe)holder.value();
                if (recipe.inputFluid == null || !HighPressureRefineryRecipe.test(recipe.inputFluid, fluid, ignoreAmount)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithSecondaryInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (RecipeHolder<HighPressureRefineryRecipe> holder : recipes.values()) {
                HighPressureRefineryRecipe recipe = (HighPressureRefineryRecipe)holder.value();
                if (recipe.inputFluidSecondary == null || !HighPressureRefineryRecipe.test(recipe.inputFluidSecondary, fluid, ignoreAmount)) continue;
                return true;
            }
        }
        return false;
    }

    public HighPressureRefineryRecipe(FluidStack output, Optional<StackWithChance> outputItem, SizedFluidIngredient inputFluid, Optional<SizedFluidIngredient> inputFluidSecondary, Integer energy, Integer time) {
        super(IPRecipeTypes.HYDROTREATER, time, energy);
        this.output = output;
        this.outputItem = outputItem.orElse(null);
        this.inputFluid = inputFluid;
        this.inputFluidSecondary = inputFluidSecondary.orElse(null);
        this.fluidOutputList = Collections.singletonList(output);
        ArrayList<SizedFluidIngredient> list = new ArrayList<SizedFluidIngredient>(2);
        list.add(inputFluid);
        if (this.inputFluidSecondary != null) {
            list.add(this.inputFluidSecondary);
        }
        this.fluidInputList = list;
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.hydrotreater_timeModifier.get(), () -> IPServerConfig.REFINING.hydrotreater_energyModifier.get());
    }

    public FluidStack getOutputFluid() {
        return this.output.copy();
    }

    @Nullable
    public StackWithChance getSecondaryItem() {
        return this.outputItem;
    }

    public SizedFluidIngredient getPrimaryInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public SizedFluidIngredient getSecondaryInputFluid() {
        return this.inputFluidSecondary;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.create();
        if (this.outputItem != null && RANDOM.nextFloat() <= this.outputItem.chance()) {
            list.add((Object)this.outputItem.stack().get());
        }
        return list;
    }

    protected IERecipeSerializer<HighPressureRefineryRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.HYDROTREATER_SERIALIZER.get();
    }
}

