/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class DistillationTowerRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, RecipeHolder<DistillationTowerRecipe>> recipes = new HashMap<ResourceLocation, RecipeHolder<DistillationTowerRecipe>>();
    private static final RandomSource RANDOM = RandomSource.create();
    @Nullable
    private final StackWithChance[] itemOutput;
    private final SizedFluidIngredient input;

    public static RecipeHolder<DistillationTowerRecipe> findRecipe(FluidStack input) {
        if (recipes.isEmpty()) {
            return null;
        }
        for (RecipeHolder<DistillationTowerRecipe> holder : recipes.values()) {
            DistillationTowerRecipe recipe = (DistillationTowerRecipe)holder.value();
            if (recipe.input == null || !recipe.input.ingredient().test(input)) continue;
            return holder;
        }
        return null;
    }

    public DistillationTowerRecipe(List<FluidStack> fluidOutput, Optional<List<StackWithChance>> itemOutput, SizedFluidIngredient input, int energy, int time) {
        super(IPRecipeTypes.DISTILLATION, time, energy);
        this.input = input;
        this.itemOutput = itemOutput.map(list -> (StackWithChance[])list.toArray(StackWithChance[]::new)).orElse(null);
        this.fluidInputList = Collections.singletonList(input);
        this.fluidOutputList = fluidOutput;
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.distillationTower_timeModifier.get(), () -> IPServerConfig.REFINING.distillationTower_energyModifier.get());
    }

    public SizedFluidIngredient getInputFluid() {
        return this.input;
    }

    public List<StackWithChance> getItemOutput() {
        if (this.itemOutput == null) {
            return Collections.emptyList();
        }
        return List.of(this.itemOutput);
    }

    protected IERecipeSerializer<DistillationTowerRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.DISTILLATION_SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        NonNullList outputs = this.getItemOutputs();
        if (outputs != null && !outputs.isEmpty()) {
            return ((ItemStack)outputs.getFirst()).copy();
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getActualItemOutputs() {
        if (this.itemOutput == null || this.itemOutput.length == 0) {
            return NonNullList.create();
        }
        NonNullList output = NonNullList.create();
        for (StackWithChance chancedStack : this.itemOutput) {
            if (!(RANDOM.nextFloat() <= chancedStack.chance())) continue;
            output.add((Object)chancedStack.stack().get());
        }
        return output;
    }

    @Deprecated(forRemoval=true)
    public double[] chances() {
        return new double[0];
    }
}

