/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class CokerUnitRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, RecipeHolder<CokerUnitRecipe>> recipes = new HashMap<ResourceLocation, RecipeHolder<CokerUnitRecipe>>();
    private final ItemStack outputItem;
    private final FluidStack outputFluid;
    private final IngredientWithSize inputItem;
    private final SizedFluidIngredient inputFluid;

    public static RecipeHolder<CokerUnitRecipe> findRecipe(ItemStack stack, FluidStack fluid) {
        for (RecipeHolder<CokerUnitRecipe> holder : recipes.values()) {
            CokerUnitRecipe recipe = (CokerUnitRecipe)holder.value();
            if (recipe.inputItem == null || !recipe.inputItem.test(stack) || recipe.inputFluid == null || !recipe.inputFluid.test(fluid)) continue;
            return holder;
        }
        return null;
    }

    public static boolean hasRecipeWithInput(@Nonnull ItemStack stack, @Nonnull FluidStack fluid) {
        Objects.requireNonNull(stack);
        Objects.requireNonNull(fluid);
        if (!stack.isEmpty() && !fluid.isEmpty()) {
            for (RecipeHolder<CokerUnitRecipe> holder : recipes.values()) {
                CokerUnitRecipe recipe = (CokerUnitRecipe)holder.value();
                if (recipe.inputItem == null || recipe.inputFluid == null || !recipe.inputItem.test(stack) || !recipe.inputFluid.test(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithInput(@Nonnull ItemStack stack, boolean ignoreAmount) {
        Objects.requireNonNull(stack);
        if (!stack.isEmpty()) {
            for (RecipeHolder<CokerUnitRecipe> holder : recipes.values()) {
                CokerUnitRecipe recipe = (CokerUnitRecipe)holder.value();
                if (recipe.inputItem == null || !CokerUnitRecipe.test(recipe.inputItem, stack, ignoreAmount)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (RecipeHolder<CokerUnitRecipe> holder : recipes.values()) {
                CokerUnitRecipe recipe = (CokerUnitRecipe)holder.value();
                if (recipe.inputFluid == null || !CokerUnitRecipe.test(recipe.inputFluid, fluid, ignoreAmount)) continue;
                return true;
            }
        }
        return false;
    }

    public CokerUnitRecipe(ItemStack outputItem, FluidStack outputFluid, IngredientWithSize inputItem, SizedFluidIngredient inputFluid, int energy, int time) {
        super(IPRecipeTypes.COKER, time, energy);
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.inputFluid = inputFluid;
        this.inputItem = inputItem;
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.cokerUnit_timeModifier.get(), () -> IPServerConfig.REFINING.cokerUnit_energyModifier.get());
    }

    public ItemStack getOutputItem() {
        return this.outputItem.copy();
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid.copy();
    }

    public IngredientWithSize getInputItem() {
        return this.inputItem;
    }

    public SizedFluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.outputItem);
        return list;
    }

    protected IERecipeSerializer<CokerUnitRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.COKER_SERIALIZER.get();
    }
}

