/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import java.util.Set;
import java.util.function.Consumer;
import lol.bai.badpackets.api.PacketReadyCallback;
import lol.bai.badpackets.api.PacketReceiver;
import lol.bai.badpackets.api.play.ClientPlayContext;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import lol.bai.badpackets.impl.handler.PacketHandlerHolder;
import lol.bai.badpackets.impl.platform.PlatformProxy;
import lol.bai.badpackets.impl.registry.CallbackRegistry;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;

public class ClientPlayPacketHandler
extends AbstractPacketHandler<ClientPlayContext, RegistryFriendlyByteBuf>
implements ClientPlayContext {
    private final Minecraft client;
    private final ClientPacketListener listener;

    public ClientPlayPacketHandler(Minecraft client, ClientPacketListener listener) {
        super("ClientPlayPacketHandler", ChannelRegistry.PLAY_S2C, ServerboundCustomPayloadPacket::new, (BlockableEventLoop<?>)client, listener.getConnection());
        this.client = client;
        this.listener = listener;
    }

    public static ClientPlayPacketHandler get() {
        ClientPacketListener listener = Minecraft.getInstance().getConnection();
        if (listener == null) {
            throw new IllegalStateException("Cannot get c2s sender when not in play stage!");
        }
        return (ClientPlayPacketHandler)((PacketHandlerHolder)listener).badpackets_handler();
    }

    @Override
    protected Packet<?> createVanillaRegisterPacket(Set<ResourceLocation> channels, Consumer<RegistryFriendlyByteBuf> buf) {
        return PlatformProxy.INSTANCE.createVanillaRegisterPlayC2SPacket((RegistryAccess)this.listener.registryAccess(), channels, buf);
    }

    @Override
    protected void onInitialChannelSyncPacketReceived() {
        this.sendInitialChannelSyncPacket();
        for (PacketReadyCallback<ClientPlayContext> callback : CallbackRegistry.CLIENT_PLAY) {
            callback.onReady(this);
        }
    }

    @Override
    protected void receiveUnsafe(PacketReceiver<ClientPlayContext, CustomPacketPayload> receiver, CustomPacketPayload payload) {
        receiver.receive(this, payload);
    }

    @Override
    public Minecraft client() {
        return this.client;
    }

    @Override
    public ClientPacketListener handler() {
        return this.listener;
    }
}

