/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class NightVisionGogglesModel
extends HumanoidModel<LivingEntity> {
    private static final String MAIN = "main";
    private static final String LENS = "lens";
    private static final String LENS_LEFT = "lens_left";
    private static final String LENS_RIGHT = "lens_right";
    private static final String FRAME = "frame";
    private final ModelPart main;
    private final ModelPart lens;
    private final ModelPart frame;

    public NightVisionGogglesModel(ModelPart part) {
        super(part);
        this.main = part.getChild(MAIN);
        this.lens = part.getChild(LENS);
        this.frame = part.getChild(FRAME);
    }

    public void renderToBuffer(PoseStack matrix, VertexConsumer buffer, int light, int overlay, int p_350361_) {
        matrix.pushPose();
        this.head.translateAndRotate(matrix);
        matrix.scale(0.6f, 0.6f, 0.6f);
        this.main.render(matrix, buffer, light, overlay);
        this.lens.render(matrix, buffer, light, overlay);
        this.frame.render(matrix, buffer, light, overlay);
        matrix.popPose();
    }

    protected Iterable<ModelPart> headParts() {
        this.main.copyFrom(this.head);
        this.lens.copyFrom(this.main);
        this.frame.copyFrom(this.main);
        return ImmutableList.of((Object)this.main, (Object)this.lens, (Object)this.frame);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild(MAIN, CubeListBuilder.create().texOffs(0, 7).addBox(-8.0f, -7.0f, 1.0f, 1.0f, 1.0f, 6.0f).addBox(7.0f, -7.0f, 1.0f, 1.0f, 1.0f, 6.0f).addBox(-7.0f, -7.0f, 7.0f, 14.0f, 1.0f, 1.0f).addBox(-8.0f, -7.0f, -6.0f, 1.0f, 2.0f, 7.0f).addBox(7.0f, -7.0f, -6.0f, 1.0f, 2.0f, 7.0f), PartPose.ZERO);
        PartDefinition lens = root.addOrReplaceChild(LENS, CubeListBuilder.create(), PartPose.ZERO);
        lens.addOrReplaceChild(LENS_LEFT, CubeListBuilder.create().texOffs(6, 0).addBox(-6.0f, -9.0f, -7.0f, 4.0f, 5.0f, 1.0f).addBox(-2.0f, -8.0f, -7.0f, 1.0f, 3.0f, 1.0f).addBox(-7.0f, -8.0f, -7.0f, 1.0f, 4.0f, 1.0f).addBox(-6.0f, -4.0f, -7.0f, 3.0f, 1.0f, 1.0f), PartPose.ZERO);
        lens.addOrReplaceChild(LENS_RIGHT, CubeListBuilder.create().texOffs(6, 0).addBox(6.0f, -8.0f, -7.0f, 1.0f, 4.0f, 1.0f).addBox(1.0f, -8.0f, -7.0f, 1.0f, 3.0f, 1.0f).addBox(2.0f, -9.0f, -7.0f, 4.0f, 5.0f, 1.0f).addBox(3.0f, -4.0f, -7.0f, 3.0f, 1.0f, 1.0f), PartPose.ZERO);
        root.addOrReplaceChild(FRAME, CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -8.0f, -8.0f, 2.0f, 3.0f, 2.0f).addBox(-2.0f, -9.0f, -8.0f, 4.0f, 1.0f, 2.0f).addBox(-2.0f, -5.0f, -8.0f, 4.0f, 1.0f, 2.0f).addBox(2.0f, -10.0f, -8.0f, 4.0f, 1.0f, 2.0f).addBox(3.0f, -3.0f, -8.0f, 3.0f, 1.0f, 2.0f).addBox(-6.0f, -10.0f, -8.0f, 4.0f, 1.0f, 2.0f).addBox(-6.0f, -3.0f, -8.0f, 3.0f, 1.0f, 2.0f).addBox(-7.0f, -9.0f, -8.0f, 1.0f, 1.0f, 2.0f).addBox(6.0f, -9.0f, -8.0f, 1.0f, 1.0f, 2.0f).addBox(-8.0f, -8.0f, -8.0f, 1.0f, 4.0f, 2.0f).addBox(7.0f, -8.0f, -8.0f, 1.0f, 4.0f, 2.0f).addBox(6.0f, -4.0f, -8.0f, 1.0f, 1.0f, 2.0f).addBox(-7.0f, -4.0f, -8.0f, 1.0f, 1.0f, 2.0f).addBox(-3.0f, -4.0f, -8.0f, 1.0f, 1.0f, 2.0f).addBox(2.0f, -4.0f, -8.0f, 1.0f, 1.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }
}

