/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature;

import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public final class FeatureBowInfo {
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_INFO_TOOLTIP.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ListIterator<MutableComponent> tooltip = event.getToolTip().listIterator();
        Item item = stack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem shootable = (ProjectileWeaponItem)item;
            Player player = event.getEntity();
            HolderLookup.Provider registries = event.getContext().registries();
            if (registries == null) {
                return;
            }
            Holder.Reference infinity = registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.INFINITY);
            if (EnchantmentHelper.getTagEnchantmentLevel((Holder)infinity, (ItemStack)stack) > 0) {
                while (tooltip.hasNext()) {
                    TranslatableContents contents;
                    String key;
                    Component line = (Component)tooltip.next();
                    ComponentContents componentContents = line.getContents();
                    if (!(componentContents instanceof TranslatableContents) || !"enchantment.minecraft.infinity".equals(key = (contents = (TranslatableContents)componentContents).getKey())) continue;
                    ChatFormatting formatting = FeatureBowInfo.getAmmo(player, shootable, stack) > 0 ? ChatFormatting.GREEN : ChatFormatting.RED;
                    tooltip.set(Component.literal((String)line.getString()).withStyle(formatting));
                }
            } else {
                tooltip.next();
                int ammo = FeatureBowInfo.getAmmo(player, shootable, stack);
                tooltip.add(ModTooltips.AMMO.args(new Object[]{ammo}).build());
            }
        }
    }

    public static int getAmmo(Player player, ProjectileWeaponItem item, ItemStack stack) {
        int ammo = 0;
        if (player == null) {
            return ammo;
        }
        ItemStack offHand = (ItemStack)player.getInventory().offhand.getFirst();
        if (item.getSupportedHeldProjectiles(stack).test(offHand)) {
            ammo += offHand.getCount();
        }
        for (ItemStack inventoryStack : player.getInventory().items) {
            if (!item.getSupportedHeldProjectiles(stack).test(inventoryStack)) continue;
            ammo += inventoryStack.getCount();
        }
        return ammo;
    }
}

