/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.material.Fluids;

public class SimpleBlockMatchWaterFeature
extends Feature<SimpleBlockConfiguration> {
    public SimpleBlockMatchWaterFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        boolean placed = false;
        SimpleBlockConfiguration config = (SimpleBlockConfiguration)context.config();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        BlockState state = config.toPlace().getState(context.random(), origin);
        if (state.canSurvive((LevelReader)level, origin)) {
            if (state.getBlock() instanceof DoublePlantBlock) {
                if (!level.isEmptyBlock(origin.above())) {
                    return false;
                }
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)state, (BlockPos)origin, (int)2);
            } else {
                placed = state.getBlock() instanceof SimpleWaterloggedBlock ? (level.isFluidAtPosition(origin, fluidstate -> fluidstate.getType() == Fluids.WATER) ? level.setBlock(origin, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2) : level.setBlock(origin, state, 2)) : level.setBlock(origin, state, 2);
            }
            return placed;
        }
        return false;
    }
}

