/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class SeaOatsBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public SeaOatsBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            BlockState ground = world.getBlockState(pos.below());
            if (!ground.isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP)) {
                return false;
            }
            return ground.is(BlockTags.SAND) || ground.is(BlockTags.DIRT);
        }
        BlockState blockstate = world.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return false;
        }
        return blockstate.getBlock() == this && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return true;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        SeaOatsBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
    }
}

