/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class FilterEntity
extends FilterBase {
    protected boolean whitelistEntity = true;
    protected String entityName = "";

    public FilterEntity(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistEntity(boolean whitelistEntity) {
        boolean prev = this.whitelistEntity;
        this.whitelistEntity = whitelistEntity;
        this.getFilter().nodeModified(this);
        this.whitelistEntity = prev;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.getFilter().nodeModified(this);
    }

    public boolean isWhitelistEntity() {
        return this.whitelistEntity;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public boolean test(Entity entity) {
        ResourceLocation res = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (this.entityName.isEmpty() || res == null) {
            return !this.whitelistEntity;
        }
        Object name = this.entityName.contains(":") ? this.entityName : "minecraft:" + this.entityName;
        return res.toString().equals(name) == this.whitelistEntity;
    }

    @Override
    public FilterType getType() {
        return FilterType.ENTITY_TYPE;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putBoolean("include", this.whitelistEntity);
        compound.putString("name", this.entityName);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.whitelistEntity = nbt.getBoolean("include");
        this.entityName = nbt.getString("name");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistEntity);
        output.writeString(this.entityName);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistEntity = input.readBoolean();
        this.entityName = input.readString();
    }
}

