/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.utils;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.utils.LogUtil;
import java.util.List;

public class ConfigUtils {
    private static List<Integer> validStages = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8));

    public static boolean validateADW(String type, Object value) {
        if (value == null) {
            LogUtil.warn(Constants.Wands.AdvancedTime + type + " is null");
            return false;
        }
        boolean result = validStages.contains((int)((Integer)value));
        if (!result) {
            LogUtil.error("Invalid " + Constants.Wands.AdvancedTime + type + ", must be 1 , 2 , 4 or 8");
        }
        return result;
    }

    public static boolean maxADW(Object value) {
        boolean result;
        if (value == null) {
            LogUtil.warn(Constants.Wands.AdvancedTime + "_max_multiplier is null");
            return false;
        }
        boolean bl = result = (Integer)value > 2 && ((Integer)value & (Integer)value - 1) == 0;
        if (!result) {
            LogUtil.error("Invalid " + Constants.Wands.AdvancedTime + "_max_multiplier , must be >= 2 and power of 2");
        }
        return result;
    }
}

