/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.ticker;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zBlockTags;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscTools;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TickerBE
extends BaseMachineBE
implements EnergyMachine,
FluidMachine,
RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);

    public TickerBE(BlockEntityType<?> p, BlockPos b, BlockState s) {
        super(p, b, s);
    }

    public TickerBE(BlockPos p, BlockState s) {
        this((BlockEntityType)zBlockEntities.TICKER.get(), p, s);
    }

    public void tickClient() {
    }

    public void tickServer() {
        if (this.isActiveRedstone()) {
            BlockPos pos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
            this.checkState(pos);
            if (((Boolean)this.getBlockState().getValue((Property)zProperties.ACTIVE)).booleanValue() && this.blockValid(pos)) {
                ServerLevel serverLevel;
                this.playSound(pos);
                this.extractFEWhenPossible();
                this.extractMBWhenPossible();
                Level level = this.level;
                if (level instanceof ServerLevel && MiscTools.isValidTickAccelBlock((ServerLevel)(serverLevel = (ServerLevel)level), (BlockState)this.level.getBlockState(pos), (BlockEntity)this.level.getBlockEntity(pos))) {
                    MiscTools.doExtraTicks((ServerLevel)serverLevel, (BlockPos)pos, (double)((Integer)CommonConfig.TICKER_TICK_RATE.get()).intValue());
                }
            }
        }
    }

    public void checkState(BlockPos pos) {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(this.canExtractFE() && this.canExtractMB())));
    }

    public boolean blockValid(BlockPos pos) {
        return !this.level.getBlockState(pos).is(zBlockTags.TICKER_DENY);
    }

    public void playSound(BlockPos pos) {
        this.level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, 100.0f, (float)LevelUtil.getRandomValue(9, this.level) * 0.1f, true);
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    @Override
    public int getStandardEnergyCost() {
        return (Integer)CommonConfig.TICKER_FE_RATE.get();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)CommonConfig.TICKER_FE_CAPACITY.get();
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.PARADOX_FLUID_HANDLER);
    }

    @Override
    public int getStandardFluidCost() {
        return (Integer)CommonConfig.TICKER_MB_RATE.get();
    }

    @Override
    public int getMaxMB() {
        return (Integer)CommonConfig.TICKER_MB_CAPACITY.get();
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }
}

