/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.thermo;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.datamaps.RecordMap;
import com.devdyna.justdynathings.datamaps.zDataMaps;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyCharger;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyGenerator;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.Actions;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ThermoBE
extends BaseMachineBE
implements FluidMachine,
EnergyGenerator,
RedstoneControlledBE,
EnergyCharger {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new HashMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>();

    public ThermoBE(BlockEntityType<?> type, BlockPos pos, BlockState b) {
        super(type, pos, b);
        this.MACHINE_SLOTS = 1;
    }

    public ThermoBE(BlockPos pos, BlockState b) {
        this((BlockEntityType)zBlockEntities.THERMOGEN.get(), pos, b);
    }

    public void tickServer() {
        RecordMap.ThermoBlockHeatSource heat = (RecordMap.ThermoBlockHeatSource)this.getHeatBlock().getBlock().builtInRegistryHolder().getData(zDataMaps.THERMO_HEAT_SOURCE);
        RecordMap.ThermoFluidCoolant coolant = (RecordMap.ThermoFluidCoolant)this.getFluidStack().getFluidHolder().getData(zDataMaps.THERMO_COOLANT);
        this.updateBlock(heat != null && coolant != null);
        if (heat != null && coolant != null && this.isActiveRedstone() && this.canExtractMB() && this.canRecieveFE()) {
            if (((Boolean)this.getBlockState().getValue((Property)zProperties.ACTIVE)).booleanValue()) {
                this.extractMBWhenPossible((int)(125.0f / coolant.coolantEfficiency()));
                this.increaseFEWhenPossible((int)(125.0f * coolant.coolantEfficiency() * heat.heatEfficiency()));
            }
            if (this.canExtractFE()) {
                Actions.providePowerAdjacent(this.level, this.getBlockPos(), this.cache, this.getEnergyStored());
            }
        }
        if (this.isActiveRedstone() && this.canExtractFE()) {
            this.chargeFEtoItemStack(this.level, this.getBlockPos(), this.getMachineHandler(), (IEnergyStorage)this.getEnergyStorage());
        }
    }

    public void updateBlock(boolean state) {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(state)));
    }

    public BlockState getHeatBlock() {
        return this.level.getBlockState(this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)));
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.MACHINE_FLUID_HANDLER);
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_GENERATORS);
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public int getStandardEnergyCost() {
        return 0;
    }

    @Override
    public int getMaxEnergy() {
        return CommonConfig.THERMOGEN_FE_CAPACITY.getAsInt();
    }

    @Override
    public int getMaxMB() {
        return CommonConfig.THERMOGEN_MB_CAPACITY.getAsInt();
    }

    @Override
    public int getStandardFluidCost() {
        return 0;
    }
}

