/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.stabilizer;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.builders._core.block.BlockBaseBE;
import com.devdyna.justdynathings.registry.builders.stabilizer.StabilizerBE;
import com.devdyna.justdynathings.registry.interfaces.block.BucketInteractive;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.DirectionUtil;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StabilizerBlock
extends BlockBaseBE
implements BucketInteractive {
    public static VoxelShape[] shapes = new VoxelShape[]{Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};

    public StabilizerBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).destroyTime(2.0f).sound(SoundType.CHAIN).pushReaction(PushReaction.BLOCK).isRedstoneConductor(BaseMachineBlock::never));
    }

    public VoxelShape getCollisionShape(BlockState s, BlockGetter w, BlockPos p, CollisionContext c) {
        return shapes[DirectionUtil.indexByStateFacing(s)];
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return shapes[DirectionUtil.indexByStateFacing(s)];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new StabilizerBE((BlockEntityType)zBlockEntities.STABILIZER.get(), p, s);
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)zProperties.ENERGIZED, (Comparable)Boolean.valueOf(false))).setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)zProperties.GOO_FOUND, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.FACING, (Comparable)(c.getPlayer().isShiftKeyDown() ? c.getClickedFace() : c.getClickedFace().getOpposite()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{zProperties.ENERGIZED, zProperties.ACTIVE, zProperties.GOO_FOUND, BlockStateProperties.FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.bucketAction(stack, state, level, pos, player, hand, hitResult);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Constants.ModAddonCheck.docCheck && !CommonConfig.DOC_WARNING.getAsBoolean()) {
            tooltipComponents.add((Component)Component.translatable((String)"justdynathings.doc.missing"));
        }
        tooltipComponents.add((Component)Component.translatable((String)("justdynathings." + Constants.Blocks.Stabilizer)));
    }
}

