/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.stabilizer;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.builders.paradox_mixer.ParadoxMixerBlock;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zBlockTags;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blocks.gooblocks.GooBlock_Base;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class StabilizerBE
extends BaseMachineBE
implements EnergyMachine,
FluidMachine {
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);

    public StabilizerBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public StabilizerBE(BlockPos pos, BlockState state) {
        this((BlockEntityType)zBlockEntities.STABILIZER.get(), pos, state);
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    public void tickServer() {
        this.updateBlock();
        Block block = this.level.getBlockState(this.getGooPos()).getBlock();
        if ((block instanceof GooBlock_Base || block instanceof ParadoxMixerBlock) && this.canExtractFE()) {
            if (((Boolean)this.level.getBlockState(this.getGooPos()).getValue((Property)zProperties.GOO_ALIVE)).booleanValue()) {
                return;
            }
            if (block instanceof GooBlock_Base) {
                this.extractFEWhenPossible();
                if (LevelUtil.chance(5, this.level)) {
                    if (((Boolean)CommonConfig.STABILIZER_TOGGLE_SOUND.get()).booleanValue()) {
                        this.applySound();
                    }
                    this.setAlive();
                }
            }
            if (block instanceof ParadoxMixerBlock && this.canExtractMB()) {
                this.extractFEWhenPossible();
                this.extractMBWhenPossible();
                this.setAlive();
            }
        }
    }

    public void setAlive() {
        this.level.setBlockAndUpdate(this.getGooPos(), (BlockState)this.level.getBlockState(this.getGooPos()).setValue((Property)GooBlock_Base.ALIVE, (Comparable)Boolean.valueOf(true)));
    }

    public void updateBlock() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)((BlockState)((BlockState)this.getBlockState().setValue((Property)zProperties.ENERGIZED, (Comparable)Boolean.valueOf(this.canExtractMB()))).setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(this.canExtractFE()))).setValue((Property)zProperties.GOO_FOUND, (Comparable)Boolean.valueOf(this.level.getBlockState(this.getGooPos()).is(zBlockTags.STABILIZER_BELOW)))).setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING))));
    }

    public void applySound() {
        if (LevelUtil.chance(5, this.level)) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, (float)(this.level.random.nextInt(50) + 1) * 0.01f, (float)this.level.random.nextInt(50) + 0.01f);
        }
    }

    public BlockPos getGooPos() {
        return this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    }

    @Override
    public int getStandardEnergyCost() {
        return (Integer)CommonConfig.STABILIZER_FE_COST.get();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)CommonConfig.STABILIZER_FE_CAPACITY.get();
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.MACHINE_FLUID_HANDLER);
    }

    @Override
    public int getStandardFluidCost() {
        return (Integer)CommonConfig.STABILIZER_MB_COST.get();
    }

    @Override
    public int getMaxMB() {
        return (Integer)CommonConfig.STABILIZER_MB_CAPACITY.get();
    }

    public boolean canReviveGoo() {
        return this.canExtractFE();
    }

    public boolean isEnergized() {
        return this.canExtractMB() && this.canReviveGoo();
    }
}

