/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.lightwand;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.types.zItems;
import com.devdyna.justdynathings.utils.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightWandBlock
extends LightBlock {
    public LightWandBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.EMPTY).replaceable().noOcclusion().isSuffocating((s, g, p) -> false).isViewBlocking((s, g, p) -> false).instabreak().mapColor(s -> (Boolean)s.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? MapColor.WATER : MapColor.NONE).lightLevel(s -> (Integer)s.getValue((Property)LightBlock.LEVEL)).pushReaction(PushReaction.DESTROY));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return context.isHoldingItem((Item)zItems.LIGHT_WAND.get()) || context.isHoldingItem((Item)zItems.ADVANCED_LIGHT_WAND.get()) ? Shapes.block() : Shapes.empty();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && ((Boolean)CommonConfig.LIGHT_WAND_CHANGE.get()).booleanValue()) {
            level.setBlock(pos, (BlockState)state.cycle((Property)LEVEL), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (LevelUtil.chance(25, level) && ((Boolean)CommonConfig.LIGHT_BLOCK_PARTICLES.get()).booleanValue()) {
            level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (double)pos.getX() + 0.5 + 0.1 * (double)random.nextInt(5) * (double)(LevelUtil.rnd50(level) ? 1 : -1), (double)pos.getY() + 0.5 + 0.1 * (double)random.nextInt(5) * (double)(LevelUtil.rnd50(level) ? 1 : -1), (double)pos.getZ() + 0.5 + 0.1 * (double)random.nextInt(5) * (double)(LevelUtil.rnd50(level) ? 1 : -1), 0.0, 0.0, 0.0);
        }
    }
}

