/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.lightwand;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.types.zBlocks;
import com.devdyna.justdynathings.registry.types.zEntityTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.FakePlayer;

public interface ILightWand {
    public boolean condToRun(ItemStack var1);

    public void consume(Player var1, ItemStack var2, InteractionHand var3);

    public int glowingDuration();

    default public InteractionResult entityGlowing(ItemStack itemStack, Player player, LivingEntity entity, InteractionHand hand) {
        if (this.checkFakePlayers(player) && this.condToRun(itemStack) && ((Boolean)CommonConfig.LIGHT_WAND_ENTITY_GLOWING.get()).booleanValue() && this.checkEntity(entity)) {
            entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, this.glowingDuration()));
            if (((Boolean)CommonConfig.LIGHT_WAND_SOUND.get()).booleanValue()) {
                player.level().playSound(player, player.getOnPos(), SoundEvents.ALLAY_ITEM_GIVEN, SoundSource.PLAYERS, 0.25f, 1.0f);
            }
            this.consume(player, itemStack, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean checkEntity(LivingEntity entity) {
        return !entity.hasEffect(MobEffects.GLOWING) && !entity.getType().is(zEntityTags.LIGHT_WAND_GLOWING_DENY) && !(entity instanceof Player) && !(entity instanceof FakePlayer) && !entity.isMultipartEntity();
    }

    default public InteractionResult itemUse(UseOnContext c) {
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        Direction dir = c.getClickedFace();
        Player player = c.getPlayer();
        ItemStack item = c.getItemInHand();
        BlockPos offset = pos.relative(dir);
        InteractionHand hand = c.getHand();
        BlockState state = level.getBlockState(pos);
        BlockState ofstate = level.getBlockState(offset);
        if (this.checkFakePlayers(player)) {
            if (player.isCrouching() && state.is((Block)zBlocks.LIGHT_WAND_BLOCK.get()) && ((Boolean)CommonConfig.LIGHT_WAND_CHANGE.get()).booleanValue()) {
                return this.changeLight(level, pos, hand, player, state);
            }
            if (ofstate.canBeReplaced() && !ofstate.is((Block)zBlocks.LIGHT_WAND_BLOCK.get()) && ((Boolean)CommonConfig.LIGHT_WAND_PLACING.get()).booleanValue()) {
                return this.createLight(player, item, hand, level, offset);
            }
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult createLight(Player player, ItemStack item, InteractionHand hand, Level level, BlockPos pos) {
        if (!player.isCreative()) {
            this.consume(player, item, hand);
        }
        FluidState fluid = level.getFluidState(pos);
        level.setBlockAndUpdate(pos, (BlockState)((Block)zBlocks.LIGHT_WAND_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(!fluid.isEmpty() && fluid.isSource() && fluid.is((Fluid)Fluids.WATER))));
        if (((Boolean)CommonConfig.LIGHT_WAND_SOUND.get()).booleanValue()) {
            player.level().playSound(player, player.getOnPos(), SoundEvents.ALLAY_ITEM_GIVEN, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult changeLight(Level level, BlockPos pos, InteractionHand hand, Player player, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LightBlock.LEVEL) == 0 ? 15 : (Integer)state.getValue((Property)LightBlock.LEVEL) - 1)), 2);
        player.swing(hand);
        if (((Boolean)CommonConfig.LIGHT_WAND_SOUND.get()).booleanValue()) {
            player.level().playSound(player, player.getOnPos(), SoundEvents.ALLAY_ITEM_GIVEN, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean checkFakePlayers(Player player) {
        return (Boolean)CommonConfig.FAKEPLAYER_LIGHT_WAND.get() != false ? true : player instanceof FakePlayer;
    }
}

