/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.lightwand;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.builders.lightwand.ILightWand;
import com.direwolf20.justdirethings.common.items.interfaces.BasePoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;

public class AdvancedLightWand
extends BasePoweredItem
implements PoweredItem,
ILightWand {
    public AdvancedLightWand() {
        super(new Item.Properties().stacksTo(1));
    }

    public int getMaxEnergy() {
        return (Integer)CommonConfig.ADVANCED_LIGHT_WAND_FE_CAPACITY.get();
    }

    public static int getFECostAtUse() {
        return (Integer)CommonConfig.ADVANCED_LIGHT_WAND_FE_COST.get();
    }

    @Override
    public boolean condToRun(ItemStack stack) {
        return PoweredItem.hasEnoughEnergy((ItemStack)stack, (int)AdvancedLightWand.getFECostAtUse());
    }

    @Override
    public void consume(Player player, ItemStack stack, InteractionHand hand) {
        PoweredItem.consumeEnergy((ItemStack)stack, (int)AdvancedLightWand.getFECostAtUse());
    }

    @Override
    public int glowingDuration() {
        return (Integer)CommonConfig.ADVANCED_LIGHT_WAND_GLOWING_DURATION.get();
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.itemUse(context);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        return this.entityGlowing(stack, player, interactionTarget, usedHand);
    }
}

