/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.goo.energy;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.GooBlockBE_Base;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FEGoo
extends GooBlockBE_Base
implements EnergyMachine {
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);

    public FEGoo(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tickServer() {
        this.checkEnergy();
        this.checkSides();
        this.tickCounters();
        this.setChanged();
    }

    public void checkEnergy() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.GOO_ALIVE, (Comparable)Boolean.valueOf(this.canExtractFE())));
    }

    public void setBlockToTarget(BlockState output, Direction direction) {
        if (output.hasProperty((Property)BlockStateProperties.FACING)) {
            this.level.setBlockAndUpdate(this.getBlockPos().relative(direction), (BlockState)output.setValue((Property)BlockStateProperties.FACING, (Comparable)direction));
        } else {
            this.level.setBlockAndUpdate(this.getBlockPos().relative(direction), output);
        }
        this.updateSideCounter(direction, -1);
        this.sidedDurations.put(direction, -1);
        if (((Boolean)CommonConfig.GOO_FEGOO_SOUND_RECIPE.get()).booleanValue()) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.SCULK_BLOCK_BREAK, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
        if (this.level != null && !this.level.isClientSide && ((Boolean)this.getBlockState().getValue((Property)zProperties.GOO_ALIVE)).booleanValue()) {
            this.extractFEWhenPossible();
            if (LevelUtil.chance(25, this.level) && ((Boolean)CommonConfig.GOO_FEGOO_SOUND_EXTRA.get()).booleanValue()) {
                this.level.playSound(null, this.getBlockPos(), this.canExtractFE() ? (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value() : SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 0.25f, 0.25f);
            }
        }
    }

    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    @Override
    public int getStandardEnergyCost() {
        return (Integer)CommonConfig.GOO_FEGOO_FE_RATE.get() * ((Boolean)CommonConfig.GOO_FEGOO_FE_RATE_MULTIPLY.get() != false ? this.getTier() : 1);
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)CommonConfig.GOO_FEGOO_FE_CAPACITY.get() * ((Boolean)CommonConfig.GOO_FEGOO_FE_CAPACITY_MULTIPLY.get() != false ? this.getTier() : 1);
    }
}

