/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.black_hole;

import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlackHoleBE
extends BaseMachineBE
implements EnergyMachine,
FluidMachine,
RedstoneControlledBE {
    public final RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);

    public BlackHoleBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.MACHINE_SLOTS = 1;
    }

    public BlackHoleBE(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)zBlockEntities.BLACKHOLE.get(), pos, blockState);
    }

    public void tickServer() {
        super.tickServer();
        if (!((Boolean)CommonConfig.BLACKHOLE_KEEP_STORAGE.get()).booleanValue() || this.isActiveRedstone()) {
            ItemStack item = this.getMachineHandler().getStackInSlot(0);
            if (!item.isEmpty()) {
                item.shrink(item.getCount());
            }
            this.extractFEWhenPossible();
            this.extractMBWhenPossible();
        }
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.MACHINE_FLUID_HANDLER);
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public int getStandardFluidCost() {
        return (Integer)CommonConfig.BLACKHOLE_MB_COST.get();
    }

    @Override
    public int getMaxMB() {
        return (Integer)CommonConfig.BLACKHOLE_MB_CAPACITY.get();
    }

    @Override
    public int getStandardEnergyCost() {
        return (Integer)CommonConfig.BLACKHOLE_FE_COST.get();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)CommonConfig.BLACKHOLE_FE_CAPACITY.get();
    }
}

