/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.compat.ae2.initApp;
import com.devdyna.justdynathings.compat.extendedae.initExtend;
import com.devdyna.justdynathings.compat.geore.initGeOre;
import com.devdyna.justdynathings.compat.phasorite.initPhaso;
import com.devdyna.justdynathings.registry.builders.RawOre;
import com.devdyna.justdynathings.registry.builders._core.item.ItemBase;
import com.devdyna.justdynathings.registry.builders._core.item.ItemFuel;
import com.devdyna.justdynathings.registry.types.zBiomeTags;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zBlockTags;
import com.devdyna.justdynathings.registry.types.zBlocks;
import com.devdyna.justdynathings.registry.types.zComponents;
import com.devdyna.justdynathings.registry.types.zContainers;
import com.devdyna.justdynathings.registry.types.zCreativeTab;
import com.devdyna.justdynathings.registry.types.zEntityTags;
import com.devdyna.justdynathings.registry.types.zFluidTypes;
import com.devdyna.justdynathings.registry.types.zFluids;
import com.devdyna.justdynathings.registry.types.zHandlers;
import com.devdyna.justdynathings.registry.types.zItemTags;
import com.devdyna.justdynathings.registry.types.zItems;
import com.devdyna.justdynathings.registry.types.zRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class Material {
    public static void register(IEventBus bus) {
        zBlockEntities.register(bus);
        zBlocks.register(bus);
        zBlockTags.register(bus);
        zContainers.register(bus);
        zCreativeTab.register(bus);
        zFluids.register(bus);
        zFluidTypes.register(bus);
        zHandlers.register(bus);
        zItems.register(bus);
        zItemTags.register(bus);
        zComponents.register(bus);
        zBiomeTags.register(bus);
        zRecipeTypes.register(bus);
        zEntityTags.register(bus);
    }

    public static DeferredHolder<Block, ?> registerItemAndBlock(String blockname, Supplier<? extends Block> sup) {
        DeferredBlock block = zBlocks.zBlockItem.register(blockname, sup);
        zItems.zBlockItem.registerSimpleBlockItem((Holder)block);
        return block;
    }

    public static TagKey<Item> tagItem(String name) {
        return Material.tagItem("justdynathings", name);
    }

    public static TagKey<EntityType<?>> tagEntity(String name) {
        return Material.tagEntity("justdynathings", name);
    }

    public static TagKey<Fluid> tagFluid(String name) {
        return TagKey.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"justdynathings", (String)name));
    }

    public static TagKey<Biome> tagBiome(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"justdynathings", (String)name));
    }

    public static TagKey<EntityType<?>> tagEntity(String modname, String name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modname, (String)name));
    }

    public static TagKey<Item> tagItem(String modname, String name) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modname, (String)name));
    }

    public static TagKey<Block> tagBlock(String name) {
        return Material.tagBlock("justdynathings", name);
    }

    public static TagKey<Block> tagBlock(String modname, String name) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modname, (String)name));
    }

    public static Block[] getBuddingAvailable() {
        ArrayList<Block> a = new ArrayList<Block>();
        a.add((Block)zBlocks.ECHOING_BUDDING_AMETHYST.get());
        a.add((Block)zBlocks.ECHOING_BUDDING_TIME.get());
        if (Constants.ModAddonCheck.AppliedEnergistics2) {
            a.add((Block)initApp.CERTUS.block().get());
        }
        if (Constants.ModAddonCheck.ExtendedAE) {
            a.add((Block)initExtend.ENTRO.block().get());
        }
        if (Constants.ModAddonCheck.PhasoriteNetworks) {
            a.add((Block)initPhaso.PHASORITE.block().get());
        }
        if (Constants.ModAddonCheck.GeOre) {
            initGeOre.values().forEach(b -> a.add((Block)b.block().get()));
        }
        Block[] b2 = new Block[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            b2[i] = (Block)a.get(i);
        }
        return b2;
    }

    public static DeferredHolder<Item, ?> createItem(String name) {
        return zItems.zItem.register(name, ItemBase::new);
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> createBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> ... validBlocks) {
        return zBlockEntities.zBE.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])Arrays.stream(validBlocks).map(Supplier::get).toArray(Block[]::new))).build(null));
    }

    public class DireStuff {
        public DireStuff(Material this$0) {
        }

        public static DeferredHolder<Block, ?> simpleGoo(String id, Supplier<? extends Block> sup) {
            DeferredBlock block = zBlocks.zGoo.register(id, sup);
            zItems.zBlockItem.registerSimpleBlockItem((Holder)block);
            return block;
        }

        public static DeferredHolder<Block, RawOre> simpleRawOreDW(String name) {
            DeferredBlock block = zBlocks.zOres.register(name, () -> new RawOre(SoundType.AMETHYST, 1.4f, 6.0f));
            zItems.zBlockItem.registerSimpleBlockItem((Holder)block);
            return block;
        }

        public static DeferredHolder<Item, ?> FuelItemDW(String name, int burnrate) {
            return zItems.zCoals.register(name, () -> new ItemFuel(burnrate));
        }

        public static DeferredHolder<Block, ?> registerBudding(String blockname, Supplier<? extends Block> sup) {
            DeferredBlock block = zBlocks.zBuddings.register(blockname, sup);
            zItems.zBlockItem.registerSimpleBlockItem((Holder)block);
            return block;
        }
    }
}

