/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.datagen.client;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.registry.types.zBlocks;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.DataGenUtil;
import com.direwolf20.justdirethings.common.blocks.gooblocks.GooBlock_Base;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DataBlockModelState
extends BlockStateProvider {
    public DataBlockModelState(PackOutput o, ExistingFileHelper f) {
        super(o, "justdynathings", f);
    }

    protected void registerStatesAndModels() {
        this.BaseGooStateModel((Block)zBlocks.CREATIVE_GOO.get());
        this.BaseGooStateModel((Block)zBlocks.ENERGIZED_GOO.get());
        this.BaseGooStateModel((Block)zBlocks.T1_GOO.get());
        this.BaseGooStateModel((Block)zBlocks.T2_GOO.get());
        this.BaseGooStateModel((Block)zBlocks.T3_GOO.get());
        this.BaseGooStateModel((Block)zBlocks.T4_GOO.get());
        this.PhaseBox((Block)zBlocks.PHASEBOX.get());
        DataGenUtil.SimpleBlock((Block)zBlocks.BLACKHOLE.get(), this);
        this.BaseSolarPanel((Block)zBlocks.FERRICORE_SOLARGEN.get(), this.modLoc("block/solar_panel/ferricore"));
        this.BaseSolarPanel((Block)zBlocks.BLAZEGOLD_SOLARGEN.get());
        this.BaseSolarPanel((Block)zBlocks.CELESTIGEM_SOLARGEN.get());
        this.BaseSolarPanel((Block)zBlocks.ECLIPSEALLOY_SOLARGEN.get());
        this.inversDirectionalBlocks((Block)zBlocks.THERMOGEN.get());
        this.AnvilStateModel((Block)zBlocks.FERRICORE_ANVIL.get());
        this.AnvilStateModel((Block)zBlocks.BLAZEGOLD_ANVIL.get());
        this.AnvilStateModel((Block)zBlocks.CELESTIGEM_ANVIL.get());
        this.AnvilStateModel((Block)zBlocks.ECLIPSEALLOY_ANVIL.get());
        DataGenUtil.BiStateBlock(this, (Block)zBlocks.PARADOX_MIXER.get(), zProperties.GOO_ALIVE, DataGenUtil.getResource("block/paradox_mixer/on"), DataGenUtil.getResource("block/paradox_mixer/off"));
        this.simpleBlock((Block)zBlocks.PARADOX_RENDER.get(), (ModelFile)this.models().getExistingFile(DataGenUtil.getResource("block/paradox_mixer/render")));
        this.getVariantBuilder((Block)zBlocks.LIGHT_WAND_BLOCK.get()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().withExistingParent(zBlocks.LIGHT_WAND_BLOCK.getRegisteredName(), this.mcLoc("block/air"))).build());
    }

    private void AnvilStateModel(Block b) {
        this.getVariantBuilder(b).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(DataGenUtil.getResource("block/anvils/" + DataGenUtil.getName(b).replace("_anvil", "")))).rotationY(state.getValue((Property)AnvilBlock.FACING) == Direction.EAST || state.getValue((Property)AnvilBlock.FACING) == Direction.WEST ? 90 : 0).build());
    }

    private void BaseGooStateModel(Block b, String modname) {
        DataGenUtil.BiStateBlock(this, b, GooBlock_Base.ALIVE, DataGenUtil.getResource("block/goo/" + DataGenUtil.getName(b) + "/alive", modname), DataGenUtil.getResource("block/goo/" + DataGenUtil.getName(b) + "/dead", modname));
    }

    private void BaseGooStateModel(Block b) {
        this.BaseGooStateModel(b, "justdynathings");
    }

    private void PhaseBox(Block b) {
        DataGenUtil.BiStateBlock(this, b, zProperties.SOLID, (ModelFile)DataGenUtil.NamewithParent("justdynathings:block/phase_box/true", this, "block/cube_all").texture("all", "justdynathings:block/phase/true"), (ModelFile)((BlockModelBuilder)DataGenUtil.NamewithParent("justdynathings:block/phase_box/false", this, "block/cube_all").texture("all", "justdynathings:block/phase/false")).renderType(DataGenUtil.CUTOUT));
    }

    private void inversDirectionalBlocks(Block block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(DataGenUtil.getResource("block/" + DataGenUtil.getName(block)));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationX(dir == Direction.UP ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : (int)dir.toYRot() % 360).build();
        });
    }

    private void BaseBuddings(Block b, ResourceLocation on, ResourceLocation off) {
        String blockname = DataGenUtil.getName(b).replace("echoing_budding_", "");
        DataGenUtil.BiStateBlock(this, b, zProperties.GOO_ALIVE, (ModelFile)this.models().getExistingFile(on), (ModelFile)this.models().getExistingFile(off));
    }

    private void BaseBuddings(Block b, ModelFile on, ResourceLocation off) {
        String blockname = DataGenUtil.getName(b).replace("echoing_budding_", "");
        DataGenUtil.BiStateBlock(this, b, zProperties.GOO_ALIVE, on, (ModelFile)this.models().getExistingFile(off));
    }

    private void BaseBuddings(Block b, ResourceLocation on, ModelFile off) {
        String blockname = DataGenUtil.getName(b).replace("echoing_budding_", "");
        DataGenUtil.BiStateBlock(this, b, zProperties.GOO_ALIVE, (ModelFile)this.models().getExistingFile(on), off);
    }

    public static BlockModelBuilder CubeAllCheap(String nameTexture, BlockStateProvider b) {
        return DataGenUtil.CubeAll(nameTexture + "/dead", b, nameTexture);
    }

    private void BaseSolarPanel(Block b) {
        String blockname = DataGenUtil.getName(b).replace("_solar_panel", "");
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)DataGenUtil.NamewithParent("justdynathings:block/solar_panel/" + blockname, this, "justdynathings:block/solar_panel/_template").texture("side", "justdynathings:block/generator/" + blockname + "/side")).texture("bottom", "justdynathings:block/generator/" + blockname + "/bottom")).texture("solar_panel", "justdynathings:block/solar_panel/" + blockname));
    }

    private void BaseSolarPanel(Block b, ResourceLocation model) {
        this.simpleBlock(b, (ModelFile)this.models().getExistingFile(model));
    }

    private void BaseGenerator(Block b) {
        String tier = Constants.Tiers.materials.get(Integer.getInteger(DataGenUtil.getName(b).replace("generatort", "")));
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)DataGenUtil.NamewithParent("justdynathings:block/generator/" + tier, this, "justdynathings:block/generator/_template").texture("side", "justdynathings:block/generator/" + tier + "/side")).texture("top", "justdynathings:block/generator/" + tier + "/top")).texture("bottom", "justdynathings:block/generator/" + tier + "/bottom"));
    }
}

