/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.compat.jei.utils;

import com.devdyna.justdynathings.compat.jei.utils.Image;
import com.devdyna.justdynathings.utils.Size;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRecipeCategory<T>
implements IRecipeCategory<T> {
    protected IGuiHelper helper;
    public final Font font;

    public BaseRecipeCategory(IGuiHelper h) {
        this.font = Minecraft.getInstance().font;
        this.helper = h;
    }

    public abstract String getTitleKey();

    public abstract ItemLike getIconItem();

    public abstract Size setXY();

    public abstract String setBackGround();

    public Component getTitle() {
        return Component.translatable((String)("justdynathings.jei.category." + this.getTitleKey()));
    }

    @Nullable
    public IDrawable getIcon() {
        return this.helper.createDrawableItemLike(this.getIconItem());
    }

    public int getWidth() {
        return this.setXY().getX();
    }

    public int getHeight() {
        return this.setXY().getY();
    }

    public void background(GuiGraphics graphics) {
        Image.of().rl(this.setBackGround()).size(this.getWidth(), this.getHeight()).render(this.helper, graphics);
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background(guiGraphics);
    }
}

