/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.compat.jei.categories.thermo;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.compat.jei.datamaps.records;
import com.devdyna.justdynathings.compat.jei.utils.BaseLabelledCategory;
import com.devdyna.justdynathings.compat.jei.utils.Image;
import com.devdyna.justdynathings.utils.Pos;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoulFireBlock;

public class ThermoHeatSource
extends BaseLabelledCategory<records.ThermoBlockHeatSource> {
    public static final RecipeType<records.ThermoBlockHeatSource> TYPE = RecipeType.create((String)"justdynathings", (String)Constants.DataMaps.Thermo.thermo_heat_sources, records.ThermoBlockHeatSource.class);

    public ThermoHeatSource(IGuiHelper guiHelper) {
        super(guiHelper);
    }

    public RecipeType<records.ThermoBlockHeatSource> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder b, records.ThermoBlockHeatSource map, IFocusGroup focuses) {
        Block block = map.block();
        if (block instanceof LiquidBlock) {
            LiquidBlock fluid = (LiquidBlock)block;
            try {
                b.addSlot(RecipeIngredientRole.INPUT, 4, 4).addItemLike((ItemLike)fluid.fluid.getBucket());
            }
            catch (Exception exception) {}
        } else if (map.block() instanceof FireBlock || map.block() instanceof SoulFireBlock) {
            try {
                item = new ItemStack((ItemLike)Items.FIRE_CHARGE);
                item.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)map.block().getDescriptionId()));
                b.addSlot(RecipeIngredientRole.INPUT, 4, 4).addItemStack(item);
            }
            catch (Exception item) {}
        } else if (map.block() instanceof LayeredCauldronBlock || map.block() instanceof LavaCauldronBlock) {
            try {
                item = new ItemStack((ItemLike)Items.CAULDRON);
                item.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)map.block().getDescriptionId()));
                b.addSlot(RecipeIngredientRole.INPUT, 4, 4).addItemStack(item);
            }
            catch (Exception exception) {}
        } else {
            b.addSlot(RecipeIngredientRole.INPUT, 4, 4).addItemLike((ItemLike)map.block().asItem());
        }
    }

    @Override
    public void draw(records.ThermoBlockHeatSource map, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(map, recipeSlotsView, guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(Minecraft.getInstance().font, "Efficiency : " + map.heatEfficiency(), 30, 8, 0x444444, false);
        Block b = map.block();
        if (b instanceof LavaCauldronBlock || b instanceof LayeredCauldronBlock || b instanceof FireBlock || b instanceof SoulFireBlock) {
            Image.of().rl("minecraft", "textures/gui/sprites/icon/unseen_notification.png").size(10, 10).offset(140, 7).render(this.helper, guiGraphics);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, records.ThermoBlockHeatSource map, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (Pos.of(140, 7).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"justdynathings.jei.warning"));
        }
    }

    @Override
    public String getTitleKey() {
        return Constants.DataMaps.Thermo.thermo_heat_sources;
    }

    @Override
    public ItemLike getIconItem() {
        return Items.MAGMA_BLOCK;
    }
}

