/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.compat.jei.categories;

import com.devdyna.justdynathings.compat.jei.utils.BaseRecipeCategory;
import com.devdyna.justdynathings.compat.jei.utils.FuelRecords;
import com.devdyna.justdynathings.utils.Pos;
import com.devdyna.justdynathings.utils.Size;
import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class FuelRecipeCategory
extends BaseRecipeCategory<FuelRecords.Items> {
    public static final RecipeType<FuelRecords.Items> TYPE = RecipeType.create((String)"justdynathings", (String)Registration.GeneratorT1_ITEM.getId().getPath(), FuelRecords.Items.class);

    public FuelRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper);
    }

    public RecipeType<FuelRecords.Items> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelRecords.Items recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 8).addItemStacks(recipe.getFuels());
    }

    @Override
    public String getTitleKey() {
        return Registration.GeneratorT1_ITEM.getId().getPath();
    }

    @Override
    public ItemLike getIconItem() {
        return (ItemLike)Registration.GeneratorT1_ITEM.get();
    }

    @Override
    public Size setXY() {
        return Size.of(96, 32);
    }

    @Override
    public String setBackGround() {
        return "textures/gui/fuel_icons.png";
    }

    @Override
    public void draw(FuelRecords.Items recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int multiplier = 1;
        Item item = recipe.getFuels().getFirst().getItem();
        if (item instanceof Coal_T1) {
            Coal_T1 c = (Coal_T1)item;
            multiplier = c.getBurnSpeedMultiplier();
        } else {
            BlockItem bi;
            item = recipe.getFuels().getFirst().getItem();
            if (item instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof CoalBlock_T1) {
                CoalBlock_T1 c = (CoalBlock_T1)item;
                multiplier = c.getBurnSpeedMultiplier();
            }
        }
        int rate = (Integer)Config.GENERATOR_T1_FE_PER_FUEL_TICK.get() * (Integer)Config.GENERATOR_T1_BURN_SPEED_MULTIPLIER.get() * multiplier;
        int total = recipe.getBurnTime() * (Integer)Config.GENERATOR_T1_FE_PER_FUEL_TICK.get();
        int maxburn = total / rate;
        PoseStack stack = guiGraphics.pose();
        stack.pushPose();
        stack.scale(0.75f, 0.75f, 8000.0f);
        guiGraphics.drawString(this.font, Screen.hasShiftDown() ? MagicHelpers.ticksInSeconds((int)maxburn).replaceAll("\\.0$", "") + " sec" : maxburn + " ticks", 46, 4, 0xFFFFFF);
        guiGraphics.drawString(this.font, rate + " FE/tick", 46, 18, 0xFFFFFF);
        guiGraphics.drawString(this.font, String.valueOf(Screen.hasShiftDown() ? MagicHelpers.withSuffix((int)total) : Integer.valueOf(total)) + " FE", 46, 32, 0xFFFFFF);
        stack.popPose();
    }

    public void getTooltip(ITooltipBuilder tooltip, FuelRecords.Items recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (Pos.of(21, 0).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"justdynathings.jei.time"));
        }
        if (Pos.of(21, 11).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"justdynathings.jei.rate"));
        }
        if (Pos.of(21, 22).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"justdynathings.jei.total"));
        }
    }
}

