/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.compat.jei;

import com.devdyna.justdynathings.client.type.paradoxMixer.ParadoxMixerScreen;
import com.devdyna.justdynathings.compat.jei.categories.FuelRecipeCategory;
import com.devdyna.justdynathings.compat.jei.categories.ParadoxMixerCategory;
import com.devdyna.justdynathings.compat.jei.categories.RefinedFuelRecipeCategory;
import com.devdyna.justdynathings.compat.jei.categories.anvils.BlazeGoldAnvil;
import com.devdyna.justdynathings.compat.jei.categories.anvils.EclipseAlloyAnvil;
import com.devdyna.justdynathings.compat.jei.categories.anvils.FerricoreAnvil;
import com.devdyna.justdynathings.compat.jei.categories.reforger.MTO;
import com.devdyna.justdynathings.compat.jei.categories.reforger.OTM;
import com.devdyna.justdynathings.compat.jei.categories.reforger.OTO;
import com.devdyna.justdynathings.compat.jei.categories.thermo.ThermoCoolant;
import com.devdyna.justdynathings.compat.jei.categories.thermo.ThermoHeatSource;
import com.devdyna.justdynathings.compat.jei.datamaps.records;
import com.devdyna.justdynathings.compat.jei.utils.FuelRecords;
import com.devdyna.justdynathings.compat.jei.utils.FuelUtils;
import com.devdyna.justdynathings.config.CommonConfig;
import com.devdyna.justdynathings.datagen.server.DataRecipe;
import com.devdyna.justdynathings.registry.types.zBlocks;
import com.devdyna.justdynathings.registry.types.zRecipeTypes;
import com.direwolf20.justdirethings.client.jei.GooSpreadRecipeCategory;
import com.direwolf20.justdirethings.client.jei.GooSpreadRecipeTagCategory;
import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.fluids.basefluids.RefinedFuel;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class PluginJei
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"justdynathings", (String)"jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ArrayList toHide = new ArrayList();
        zBlocks.zBlockItem.getEntries().forEach(b -> {
            if (!DataRecipe.denyClearBlocks.contains(b.get())) {
                Minecraft.getInstance().level.getRecipeManager().byKey(ResourceLocation.parse((String)(String.valueOf(b.getId()) + "_clear_nbt"))).ifPresent(r -> toHide.add(r));
            }
        });
        jeiRuntime.getRecipeManager().hideRecipes(RecipeTypes.CRAFTING, toHide);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        List<RecipeType> recipeTypes = List.of(GooSpreadRecipeCategory.TYPE, GooSpreadRecipeTagCategory.TYPE);
        List<Block> gooBlocks = List.of((Block)zBlocks.CREATIVE_GOO.get(), (Block)zBlocks.ENERGIZED_GOO.get(), (Block)zBlocks.T1_GOO.get(), (Block)zBlocks.T2_GOO.get(), (Block)zBlocks.T3_GOO.get(), (Block)zBlocks.T4_GOO.get());
        gooBlocks.forEach(b -> recipeTypes.forEach(t -> r.addRecipeCatalyst(new ItemStack((ItemLike)b), new RecipeType[]{t})));
        r.addRecipeCatalyst((ItemLike)zBlocks.FERRICORE_ANVIL.get(), new RecipeType[]{FerricoreAnvil.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.BLAZEGOLD_ANVIL.get(), new RecipeType[]{BlazeGoldAnvil.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.ECLIPSEALLOY_ANVIL.get(), new RecipeType[]{EclipseAlloyAnvil.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.THERMOGEN.get(), new RecipeType[]{ThermoHeatSource.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.THERMOGEN.get(), new RecipeType[]{ThermoCoolant.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.REFORGER.get(), new RecipeType[]{OTO.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.REFORGER.get(), new RecipeType[]{OTM.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.REFORGER.get(), new RecipeType[]{MTO.TYPE});
        r.addRecipeCatalyst((ItemLike)zBlocks.PARADOX_MIXER.get(), new RecipeType[]{ParadoxMixerCategory.TYPE});
        r.addRecipeCatalyst((ItemLike)Registration.GeneratorT1_ITEM.get(), new RecipeType[]{FuelRecipeCategory.TYPE});
        r.addRecipeCatalyst((ItemLike)Registration.GeneratorFluidT1_ITEM.get(), new RecipeType[]{RefinedFuelRecipeCategory.TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper h = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new FerricoreAnvil(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new BlazeGoldAnvil(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new EclipseAlloyAnvil(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new ThermoHeatSource(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new ThermoCoolant(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new OTO(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new OTM(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new MTO(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new ParadoxMixerCategory(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new FuelRecipeCategory(h)});
        r.addRecipeCategories(new IRecipeCategory[]{new RefinedFuelRecipeCategory(h)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        RecipeManager recipes = Minecraft.getInstance().level.getRecipeManager();
        r.addRecipes(FerricoreAnvil.TYPE, records.FerricoreItemRepair.get());
        r.addRecipes(BlazeGoldAnvil.TYPE, records.BlazeGoldFluidRepair.get());
        r.addRecipes(EclipseAlloyAnvil.TYPE, records.EclipseAlloyFluidRepair.get());
        r.addRecipes(ThermoHeatSource.TYPE, records.ThermoBlockHeatSource.get());
        r.addRecipes(ThermoCoolant.TYPE, records.ThermoFluidCoolant.get());
        r.addRecipes(OTO.TYPE, recipes.getAllRecipesFor(zRecipeTypes.REFORGER_OTO.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(OTM.TYPE, recipes.getAllRecipesFor(zRecipeTypes.REFORGER_OTM.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(MTO.TYPE, recipes.getAllRecipesFor(zRecipeTypes.REFORGER_MTO.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(ParadoxMixerCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.PARADOX_MIXER.getType()).stream().map(RecipeHolder::value).toList());
        HashMap<Integer, List> fuels = new HashMap<Integer, List>();
        for (ItemStack stack : FuelUtils.getAllSolidFuels()) {
            BlockItem bi;
            Item item;
            int burnTime = stack.getBurnTime(net.minecraft.world.item.crafting.RecipeType.SMELTING);
            if (stack.getItem() instanceof Coal_T1 || (item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof CoalBlock_T1) {
                r.addRecipes(FuelRecipeCategory.TYPE, List.of(new FuelRecords.Items(List.of(stack))));
                continue;
            }
            if (burnTime <= 0) continue;
            fuels.computeIfAbsent(burnTime, k -> new ArrayList()).add(stack);
        }
        if (((Boolean)CommonConfig.ENABLE_ALL_JEI_FUELS.get()).booleanValue()) {
            fuels.entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).forEach(entry -> r.addRecipes(FuelRecipeCategory.TYPE, List.of(new FuelRecords.Items((List)entry.getValue()))));
        }
        FuelUtils.getAllRefinedFuels().stream().collect(Collectors.groupingBy(f -> ((RefinedFuel)f.getFluid()).fePerMb())).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(f -> r.addRecipes(RefinedFuelRecipeCategory.TYPE, List.of(new FuelRecords.Fluids((List)f.getValue()))));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration r) {
        r.addRecipeClickArea(ParadoxMixerScreen.class, 28, -8, 48, 48, new RecipeType[]{ParadoxMixerCategory.TYPE});
    }
}

